import {Injectable} from '@angular/core';
import {BraintreeCheckoutAdapter} from '../../braintree-checkout/connectors';
import {HttpClient, HttpHeaders, HttpParams} from '@angular/common/http';
import {Address, ConverterService, OccEndpointsService} from '@spartacus/core';
import {Observable} from 'rxjs';
import {map} from 'rxjs/operators';
import {PriceValueData} from '../../braintree-checkout/models';
import {PRICE_VALUE_DATA_NORMALIZER} from '../../braintree-checkout/braintree-checkout-store/converters';


@Injectable()
export class DefaultBraintreeCheckoutAdapter
    implements BraintreeCheckoutAdapter
{
  constructor(
      protected http: HttpClient,
      protected occEndpoints: OccEndpointsService,
      protected converter: ConverterService
  ) {}

  protected getEndpoint(
      userId: string,
      cartId: string
  ): string {
    return this.occEndpoints.getEndpoint('/users/' + userId + '/carts/' + cartId + '/braintree');
  }

  proceedExpressCheckout(
      paymentDetailsId: string,
      userId: string,
      cartId: string,
      address: Address): Observable<boolean> {
    const url = this.getEndpoint(userId, cartId) + '/express';
    const params = new HttpParams().set('paymentDetailsId', paymentDetailsId);

    const headers = new HttpHeaders({
      'Content-Type': 'application/json',
    });

    return this.http.post(url, address, {headers, params})
    .pipe(
        map(value => {
          return !!value;
        })
    );
  }

  countDeliveryPrice(
      countryCode: string,
      userId: string,
      cartId: string): Observable<PriceValueData> {
    const url = this.getEndpoint(userId, cartId) + '/countprice';

    const params = new HttpParams()
    .set('countryCode', countryCode);

    return this.http.get(url, { params })
    .pipe(this.converter.pipeable(PRICE_VALUE_DATA_NORMALIZER));
  }

}
