import {Injectable} from '@angular/core';
import {BraintreeUtilsService} from '../utils';
import * as braintree from 'braintree-web';
import {CheckoutData, PageType} from '../../models';
import {BraintreeCheckoutService} from '../checkout';

@Injectable({
  providedIn: 'root'
})
export class BraintreeSrcCheckoutService {

  protected deviceData;
  protected pageType: PageType;

  constructor(
    protected braintreeUtils: BraintreeUtilsService,
    protected braintreeCheckoutService: BraintreeCheckoutService
  ) {
  }

  initializeSrc(checkoutData: CheckoutData, pageType: PageType): void {
    this.pageType = pageType;

    this.braintreeUtils.createClientInstance(checkoutData.configurationData, (client, deviceData) => {
      this.deviceData = deviceData;

      braintree.visaCheckout.create({
        client
      }, (visaCheckoutErr, visaCheckoutInstance) => {

        if (visaCheckoutErr) {
          console.error('Error creating VisaCheckout:', visaCheckoutErr);
          return;
        }
        this.braintreeUtils.loadSdk(checkoutData.srcPaymentMethod.srcSdkUrl,
            () => {
          this.visaCheckoutInitialized(visaCheckoutInstance, checkoutData);
        });

      });


    });
  }

  protected visaCheckoutInitialized(visaCheckoutInstance, checkoutData: CheckoutData): void {
    const baseInitOptions = {
      paymentRequest: {
        currencyCode: checkoutData.configurationData.currency,
        subtotal: this.braintreeUtils.getTotalAmountBeforeRendering()?.toFixed(2)
      }
    };

    const initOptions = visaCheckoutInstance.createInitOptions(baseInitOptions);

    (window as any).V.init(initOptions);

    (window as any).V.on('payment.success', (payment) => {
      visaCheckoutInstance.tokenize(payment, (tokenizeErr, payload) => {
        if (tokenizeErr) {
          console.error('Error during Visa Checkout tokenization', tokenizeErr);
        } else {
          this.braintreeCheckoutService.processSrcResponse(
              payload,
              this.deviceData,
              this.pageType
          );
        }
      });
    });
  }

}
