import {PayPalAddress} from './braintree-payment-data.model';
import { Occ, Address } from '@spartacus/core';
import PaymentDetails = Occ.PaymentDetails;

export enum PageType{
  BILLING = 'BILLING',
  CART = 'CART',
  MY_ACCOUNT = 'ACCOUNT',
  REVIEW = 'REVIEW',
  OVERVIEW = 'OVERVIEW'
}

export enum Fields{
  Basic = 'BASIC',
  Default = 'DEFAULT',
  Full = 'FULL'
}

declare module '@spartacus/core' {
  export interface PaymentDetails {
    cardholderName?: string;
    paypalFundingSource?: string;
  }

}

export class VenmoPaymentData{
  details: {
    username?: string;
  };
  nonce?: string;
  type?: string;
}

export interface PayPalDetail{
  email?: string;
  firstName?: string;
  lastName?: string;
  countryCode?: string;
  payerId?: string;
  phone?: string;
  billingAddress?: PayPalAddress;
}

export interface PayPalPaymentRequest{
  nonce: string;
  type: string;
  details: PayPalDetail;
}

export interface GooglePayAddress{
  address1: string;
  address2: string;
  administrativeArea: string;
  countryCode: string;
  locality: string;
  name: string;
  phoneNumber: string;
  postalCode: string;
}

export interface GooglePayPaymentRequest{
  nonce: string;
  type: string;
  email: string;
  cardType: string;
  lastFour: string;
  billingAddress: GooglePayAddress;
}

export interface BraintreeCreditCardDetail{
  cardholderName?: string;
  expirationMonth?: string;
  expirationYear?: string;
  bin?: string;
  cardType?: string;
  lastFour?: string;
  lastTwo?: string;
}


export interface BraintreeTokenizedCreditCard{
  nonce?: string;
  details?: BraintreeCreditCardDetail;
  description?: string;
  type?: string;
  liabilityShifted?: string;
}

export interface BraintreeCreditCardPaymentDetails extends PaymentDetails{
  billingAddress?: Address;
  tokenizedCardData: BraintreeTokenizedCreditCard;
}

export interface ApplePayAddress{
  addressLines?: string[];
  administrativeArea?: string;
  countryCode?: string;
  locality?: string;
  givenName?: string;
  familyName?: string;
  postalCode?: string;
  phoneNumber?: string;
  emailAddress?: string;
}

export interface ApplePayPaymentRequest{
  nonce?: string;
  type?: string;
  email?: string;
  cardType?: string;
  billingContact?: ApplePayAddress;
}

export interface LocalPaymentDetailsRequest{
  email?: string;
}

export interface LocalPaymentRequest{
  nonce?: string;
  correlationId?: string;
  paymentId?: string;
  details?: LocalPaymentDetailsRequest;
}

export interface SrcAddress{
  countryCode?: string;
  firstName?: string;
  lastName?: string;
  locality?: string;
  postalCode?: string;
  phoneNumber?: string;
  region?: string;
  streetAddress?: string;
}

export interface SrcPaymentRequest{
  nonce?: string;
  details?: BraintreeCreditCardDetail;
  description?: string;
  type?: string;
  billingAddress?: SrcAddress;
  userEmail?: string;
  userFullName?: string;
}
