import { PaymentDetails } from '@spartacus/core';

export interface PayPalAddress{
  recipientName?: string;
  type?: string;
  streetAddress?: string;
  extendedAddress?: string;
  locality?: string;
  countryCodeAlpha2?: string;
  postalCode?: string;
  region?: string;
  phone?: string;
  line1?: string;
  line2?: string;
  city?: string;
  countryCode?: string;
  state?: string;
}

export interface PayPalConfiguration{
  client_id?: string;
  braintreeLocale?: string;
  currencyMerchantAccountId?: string;
  endpointURL?: string;
  userAction?: string;
  advancedFraudTools?: string;
  environment?: string;
  dbaName?: string;
  singleUse?: string;
  storeInVault?: string;
  locale?: string;
  currency?: string;
  intent?: string;
  graphQLEnabled?: boolean;
}

export interface PayPalPaymentMethod{
  payPalStandardEnabled?: boolean;
  payPalExpressEnabled?: boolean;
  shouldRenderPayPalChangePaymentButton?: boolean;
  billingAgreementDescription?: string;
  creditEnabled?: boolean;
  disableFunding?: string;
  isPayLaterForNonUsCountriesEnabled?: boolean;
  shouldShowShippingAddressMessage?: boolean;
}

export interface CreditCardPaymentMethod{
  hostedFieldsEnable?: boolean;
  secure3d?: boolean;
  skip3dSecureLiabilityResult?: boolean;
  paymentsImagesUrl?: Array<PaymentImageUrl>;
}

export interface BraintreeAssets{
  applePayLogo?: string;
  googlePayLogo?: string;
  venmoLogo?: string;
  venmoMarkImg?: string;
}

export interface PaymentImageUrl{
  key: string;
  value: string;
}

export interface ApplePayPaymentMethod{
  applePayEnabled?: string;
}

export interface GooglePayPaymentMethod{
  googleMerchantId?: string;
  googlePayCountryCode?: string;
  googlePayEnabled?: string;
}

export interface BraintreeLocalPaymentMethod{
  code?: string;
  name?: string;
  isEnabled?: boolean;
  pathToImage?: string;
  altText?: string;
}

export interface LocalPaymentMethod{
  localPaymentMethodsEnabled?: boolean;
  localPaymentMethods?: BraintreeLocalPaymentMethod[];
}

export interface VenmoPaymentMethod{
  venmoEnabled?: boolean;
  venmoProfileId?: string;
}

export interface SrcPaymentMethod{
  srcEnabled?: boolean;
  srcSdkUrl?: string;
  srcImgUrl?: string;
}

export interface DropInData{
  dropInEnabled?: boolean;
  isLimitedDeletePaymentMethods?: boolean;
  showWarningMessageAboutReplenishmentDropIn?: boolean;
}

export interface CheckoutData{
  shippingAddressOverride?: PayPalAddress;
  enableShippingAddress?: boolean;
  configurationData?: PayPalConfiguration;
  payPalPaymentMethod?: PayPalPaymentMethod;
  creditCardPaymentMethod: CreditCardPaymentMethod;
  applePayPaymentMethod: ApplePayPaymentMethod;
  googlePayPaymentMethod: GooglePayPaymentMethod;
  localPaymentMethod?: LocalPaymentMethod;
  venmoPaymentMethod?: VenmoPaymentMethod;
  srcPaymentMethod?: SrcPaymentMethod;
  dropIn?: DropInData;
}

export interface PriceValueData {
  value?: number;
  currency: string;
}

export interface BraintreePaymentDetails extends PaymentDetails{
  paymentMethodNonce: string;
  bin: string;
  payer: string;
}
