import {Observable} from 'rxjs';
import {DropInButtonStyle, PayPalButtonStyle} from '../models/paypal-button-style.model';
import {BraintreeAssets, CheckoutData} from '../models/braintree-payment-data.model';

export abstract class PaymentAdapter{

  abstract loadPaymentDetails(
    paymentMethod: string,
    userId: string,
    cartId?: string,
    pageType?: string
  ): Observable<CheckoutData>;

  abstract getPayPalButtonStyles(
    userId: string,
    buttonType?: string
  ): Observable<PayPalButtonStyle>;

  abstract getDropInButtonStyle(
      userId: string,
      buttonType?: string
  ): Observable<DropInButtonStyle>;

  abstract getBraintreeAssets(): Observable<BraintreeAssets>;

}
