import {BraintreePaymentDetails, PageType, SrcPaymentRequest} from '../models';
import {Injectable} from '@angular/core';
import {Observable} from 'rxjs';
import {Occ, Order} from '@spartacus/core';
import {PaymentDetailsAdapter} from './payment-details.adapter';
import {
  ApplePayPaymentRequest,
  BraintreeCreditCardPaymentDetails,
  Fields,
  GooglePayPaymentRequest,
  LocalPaymentRequest,
  PayPalPaymentRequest,
  VenmoPaymentData
} from '../models/braintree-payment-methods.model';
import PaymentDetails = Occ.PaymentDetails;

@Injectable()
export class BraintreePaymentDetailsConnector{
  constructor(protected adapter: PaymentDetailsAdapter) {}

  public saveVenmoPaymentDetails(
    userId: string,
    selectedAddressCode: string,
    venmoPayment: VenmoPaymentData,
    cartId?: string,
    shouldBeSaved?: boolean,
    deviceData?: string,
    fields?: Fields
  ): Observable<PaymentDetails>{
   return  this.adapter.saveVenmoPaymentDetails(userId, selectedAddressCode, venmoPayment, cartId, shouldBeSaved,
     deviceData, fields);
  }

  public savePayPalPaymentDetails(
    credit: boolean,
    shouldBeSaved: boolean,
    payPalRequest: PayPalPaymentRequest,
    pageType: PageType,
    userId: string,
    cartId?: string,
    deviceData?: string,
    fields?: Fields,
    fundingSource?: string
  ): Observable<PaymentDetails>{
    return this.adapter.savePayPalPaymentDetails(credit, payPalRequest, pageType, userId, cartId, shouldBeSaved, deviceData, fields, fundingSource);
  }

  public saveGooglePayPaymentDetails(
  userId: string,
  googlePayRequest: GooglePayPaymentRequest,
  shouldBeSaved: boolean,
  cartId?: string,
  deviceData?: string,
  fields?: Fields
): Observable<PaymentDetails>{
    return this.adapter.saveGooglePayPaymentDetails(userId, googlePayRequest, shouldBeSaved, cartId, deviceData, fields);
  }

  public saveSrcPaymentDetails(
      userId: string,
      srcRequest: SrcPaymentRequest,
      shouldBeSaved: boolean,
      cartId?: string,
      deviceData?: string,
      fields?: Fields
  ): Observable<PaymentDetails>{
    return this.adapter.saveSrcPaymentDetails(userId, srcRequest, shouldBeSaved, cartId, deviceData, fields);
  }

  public saveCreditCardPaymentDetails(
    userId: string,
    paymentDetails: BraintreeCreditCardPaymentDetails,
    selectedAddressCode: string,
    cartId?: string,
    shouldBeSaved?: boolean,
    deviceData?: string,
    fields?: Fields
  ): Observable<PaymentDetails>{
    return this.adapter
      .saveCreditCardPaymentDetails(userId, paymentDetails, selectedAddressCode, cartId, shouldBeSaved, deviceData, fields);
  }

  public saveApplePayPaymentDetails(
    userId: string,
    applePayRequest: ApplePayPaymentRequest,
    cartId?: string,
    deviceData?: string,
    fields?: Fields
  ): Observable<PaymentDetails>{
    return this.adapter.saveApplePayPaymentDetails(userId, applePayRequest, cartId, deviceData, fields);
  }

  public saveLocalPaymentMethodPaymentDetails(
    userId: string,
    cartId: string,
    localPaymentRequest: LocalPaymentRequest,
    deviceData?: string,
    fields?: Fields
  ): Observable<Order>{
    return this.adapter.processLocalPayment(userId, cartId, localPaymentRequest, deviceData, fields);
  }

  public savePaymentIdForLPM(
    userId: string,
    cartId: string,
    paymentId: string
  ): Observable<{}> {
    return this.adapter.savePaymentIdForLPM(userId, cartId, paymentId);
  }

  public processLPMFallback(
    localPaymentRequest: LocalPaymentRequest,
    currencyFromFallbackURL: string,
    deviceData?: string,
    fields?: Fields,
  ): Observable<Order>{
    return this.adapter.processLPMFallback(localPaymentRequest, currencyFromFallbackURL, deviceData, fields);
  }

  public getBraintreePaymentDetails(
    userId: string,
    saved: boolean,
    fields?: Fields
  ): Observable<BraintreePaymentDetails[]>{
    return this.adapter.getBraintreePaymentDetails(userId, saved, fields);
  }

  public getBraintreePaymentDetailsById(
    userId: string,
    paymentId: string,
    fields?: Fields
  ): Observable<BraintreePaymentDetails>{
    return this.adapter.getBraintreePaymentDetailsById(userId, paymentId, fields);
  }


  public selectBraintreePaymentMethod(
    userId: string,
    cartId: string,
    selectedPaymentMethodId: string,
    selectedPaymentMethodNonce: string
  ): Observable<{}>{
    return this.adapter.selectBraintreePaymentMethod(userId, cartId, selectedPaymentMethodId, selectedPaymentMethodNonce);
  }


}
