import { BraintreeErrorHandlerService } from './services/errorHandling/braintree-error-handler.service';
import {ModuleWithProviders, NgModule} from '@angular/core';
import {BraintreePaymentDetailsService} from './facade/braintree-payment-details.service';
import {BraintreePaymentDetailsConnector} from './connectors/braintree-payment-details.connector';
import {BraintreeCheckoutConnector} from './connectors/braintree-checkout.connector';
import {BraintreeCheckoutStoreModule} from './braintree-checkout-store/braintree-checkout-store.module';
import {
  APPLE_PAY_ADDRESS_SERIALIZER,
  GOOGLE_PAY_ADDRESS_SERIALIZER,
  PAYPAL_ADDRESS_SERIALIZER, SRC_ADDRESS_SERIALIZER,
  VENMO_PAYMENT_DETAILS_SERIALIZER
} from './braintree-checkout-store/converters/converters';
import {PaypalAddressSerializer} from './braintree-checkout-store/converters/paypal-address-serializer';
import {GooglePayAddressSerializer} from './braintree-checkout-store/converters/google-pay-address-serializer';
import {VenmoPaymentDetailsSerializer} from './braintree-checkout-store/converters/venmo-payment-details-serializer';
import { ApplePayAddressSerializer } from './braintree-checkout-store/converters/apple-pay-address-serializer';
import {HttpErrorHandler } from '@spartacus/core';
import {SrcAddressSerializer} from './braintree-checkout-store/converters/src-address-serializer';

@NgModule({
  declarations: [],
  providers: [
    BraintreePaymentDetailsService,
    BraintreePaymentDetailsConnector,
    BraintreeCheckoutConnector,
    {
      provide: PAYPAL_ADDRESS_SERIALIZER,
      useClass: PaypalAddressSerializer,
      multi: true
    },
    {
      provide: APPLE_PAY_ADDRESS_SERIALIZER,
      useClass: ApplePayAddressSerializer,
      multi: true
    },
    {
      provide: GOOGLE_PAY_ADDRESS_SERIALIZER,
      useClass: GooglePayAddressSerializer,
      multi: true
    },
    {
      provide: VENMO_PAYMENT_DETAILS_SERIALIZER,
      useClass: VenmoPaymentDetailsSerializer,
      multi: true
    },
    {
      provide: SRC_ADDRESS_SERIALIZER,
      useClass: SrcAddressSerializer,
      multi: true
    },
    {
      provide: HttpErrorHandler,
      useExisting: BraintreeErrorHandlerService,
      multi: true
    }
  ],
  imports: [
    BraintreeCheckoutStoreModule.forRoot()
  ]
})
export class BraintreeCheckoutModule {
  static forRoot(): ModuleWithProviders<BraintreeCheckoutModule> {
    return {
      ngModule: BraintreeCheckoutModule,
    };
  }
}
