import * as checkoutReducer from './braintree-checkout.reducer';
import {PaymentDetailsState} from '../braintree-payment-details-state';
import {ActionReducerMap} from '@ngrx/store';
import {InjectionToken, Provider} from '@angular/core';

export const PAYMENT_DETAILS_DATA = '[PaymentDetails] PaymentDetails Data';

export function getReducers(): ActionReducerMap<PaymentDetailsState> {
  return {
    paymentDetails: checkoutReducer.paymentDetailsReducer
  };
}

export const reducerToken: InjectionToken<ActionReducerMap<
  PaymentDetailsState
  >> = new InjectionToken<ActionReducerMap<PaymentDetailsState>>('BraintreeCheckoutReducer');

export const reducerProvider: Provider = {
  provide: reducerToken,
  useFactory: getReducers,
};
