import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';

import { AppComponent } from './app.component';
import { translations, translationChunksConfig } from '@spartacus/assets';
import {
  B2cStorefrontModule,
} from '@spartacus/storefront';
import { BraintreeStorefrontModule, defaultBraintreeCheckoutConfig } from 'braintree-spartacus-storefront';
import {provideDefaultConfig} from '@spartacus/core';

@NgModule({
  declarations: [
    AppComponent
  ],
  imports: [
    BrowserModule,
    BraintreeStorefrontModule.withConfig({
      braintreeCheckout: {
        allowGuestExpressCheckout: true
      }
    }),
    B2cStorefrontModule.withConfig({
      backend: {
        occ: {
          baseUrl: 'https://localhost:9002',
          prefix: '/rest/v2/'
        }
      },
      context: {
        currency: ['USD', 'JPY', 'EUR'],
        language: ['en'],
        baseSite: ['electronics-spa']
      },
      i18n: {
        resources: translations,
        chunks: translationChunksConfig,
        fallbackLang: 'en'
      },
      checkout: {
        guest: true
      },
      features: {
        level: '3.1'
      }
    })
  ],
  providers: [provideDefaultConfig(defaultBraintreeCheckoutConfig)],
  bootstrap: [AppComponent]
})
export class AppModule { }
