import {Component, Input, OnInit} from '@angular/core';
import {OccConfig, PaymentDetails} from '@spartacus/core';
import {Observable} from 'rxjs';
import {paymentText} from 'braintree-spartacus-core';
import {CardComponent} from '@spartacus/storefront';
import {BraintreePaymentDetailsService, BraintreeAssets} from 'braintree-spartacus-core';

@Component({
  selector: 'bt-payment-info',
  templateUrl: './braintree-payment-info.component.html'
})
export class BraintreePaymentInfoComponent extends CardComponent implements OnInit{
  contextPath$: string;
  braintreeAssets$: Observable<BraintreeAssets>;

  paymentText = paymentText;
  @Input()
  editMode = false;

  @Input()
  paymentDetails: PaymentDetails;

  @Input()
  title: Observable<string>;

  constructor(
    protected braintreePaymentDetailsService: BraintreePaymentDetailsService,
    protected config: OccConfig
  ) {
    super();
  }

  ngOnInit(): void {
    this.contextPath$ = this.config.backend.occ.baseUrl;
    this.braintreeAssets$ = this.braintreePaymentDetailsService.getBraintreeAssets();
  }

}
