import {Component} from '@angular/core';
import {
  ActiveCartService,
  CheckoutCostCenterService,
  CheckoutDeliveryService,
  CheckoutPaymentService,
  PaymentTypeService,
  TranslationService,
  UserAddressService,
  UserCostCenterService,
} from '@spartacus/core';


import {Card, CheckoutStepService, PromotionService, ReviewSubmitComponent} from '@spartacus/storefront';
import {Observable} from 'rxjs';
import { BraintreePaymentMethodsUtilsService, BraintreePaymentDetails } from 'braintree-spartacus-core';

@Component({
  selector: 'bt-review-order',
  templateUrl: './braintree-review-order.component.html'
})
export class BraintreeReviewOrderComponent extends ReviewSubmitComponent {
  title$: Observable<string>;
  constructor(
    protected checkoutDeliveryService: CheckoutDeliveryService,
    protected checkoutPaymentService: CheckoutPaymentService,
    protected userAddressService: UserAddressService,
    protected activeCartService: ActiveCartService,
    protected translation: TranslationService,
    protected promotionService: PromotionService,
    protected checkoutStepService: CheckoutStepService,
    protected paymentTypeService: PaymentTypeService,
    protected checkoutCostCenterService: CheckoutCostCenterService,
    protected userCostCenterService: UserCostCenterService,
    protected braintreePaymentMethodsUtilsService: BraintreePaymentMethodsUtilsService
  ) {
    super(checkoutDeliveryService, checkoutPaymentService, userAddressService, activeCartService, translation, promotionService,
      checkoutStepService, paymentTypeService, checkoutCostCenterService, userCostCenterService);
    this.title$ = this.translation.translate('paymentForm.payment');
  }


  getPaymentMethodCardBraintree(paymentDetails: BraintreePaymentDetails): Observable<Card> {
    return this.braintreePaymentMethodsUtilsService.getPaymentMethodCardBraintreeReviewOrder(paymentDetails);
  }
}
