import {ChangeDetectionStrategy, Component, OnInit} from '@angular/core';
import {ActiveCartService} from '@spartacus/core';
import {CartTotalsComponent} from '@spartacus/storefront';
import {
  BraintreeExpressCheckoutService,
  BraintreePaymentDetailsService,
  BraintreeUtilsService,
  CheckoutData,
  PageType,
  PaypalCheckoutService
} from 'braintree-spartacus-core';
import {first} from 'rxjs/operators';
import {Observable} from 'rxjs';

@Component({
  selector: 'bt-cart-totals',
  templateUrl: './braintree-cart-totals.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class BraintreeCartTotalsComponent extends CartTotalsComponent implements OnInit {

  loadedCheckoutData$: Observable<CheckoutData>;

  constructor(
      protected activeCartService: ActiveCartService,
      protected payPalCheckoutService: PaypalCheckoutService,
      protected braintreeExpressCheckoutService: BraintreeExpressCheckoutService,
      protected braintreeUtils: BraintreeUtilsService,
      protected braintreePaymentDetailsService: BraintreePaymentDetailsService
  ) {
    super(activeCartService);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.loadedCheckoutData$ = this.braintreePaymentDetailsService.loadPaymentDetailsForBillingPage('full', PageType.CART);
    this.cart$
    .subscribe(cart => {
      const countryCode = this.payPalCheckoutService.getCountyCode();
      if (countryCode) {
        this.braintreeExpressCheckoutService.countDeliveryPrice(countryCode)
        .pipe(first())
        .subscribe(priceData => {
          const subtotal: number = this.braintreeUtils.getSubTotalAmount();
          this.payPalCheckoutService.updatePayPalOptionsAmount(subtotal + priceData.value);
        });
      }
    });
  }

}
