import {ModuleWithProviders, NgModule} from '@angular/core';
import {CmsConfig, ConfigModule, I18nModule, provideConfig, UrlModule} from '@spartacus/core';
import {RouterModule, Routes} from '@angular/router';
import {
  BraintreeAddPaymentMethodMyaccountComponent,
  BraintreeAddressComponent,
  BraintreeBillingComponent,
  BraintreeCartComponent,
  BraintreeCartTotalsComponent,
  BraintreeHostedFieldsComponent,
  BraintreeOrderConfirmationComponent,
  BraintreeOrderDetailShippingComponent,
  BraintreeOrderOverviewComponent,
  BraintreePaymentInfoComponent,
  BraintreePaymentMethodComponent,
  BraintreePaymentMethodsMyaccountComponent,
  BraintreeReviewOrderComponent,
  BraintreeSelectAddressMyaccountComponent,
  PaypalCreditMessageComponent,
  BraintreeDropInComponent,
  LPMFallbackComponent, BraintreeReplenishmentOrderComponent,
  BraintreeCartDropInComponent,
  BraintreeMyaccountDropInComponent
} from './components/index';
import {FormsModule, ReactiveFormsModule} from '@angular/forms';
import {
  AddressBookModule,
  AddressFormModule, B2cStorefrontModule,
  CardModule, CartNotEmptyGuard,
  CartSharedModule, CheckoutAuthGuard,
  CmsPageGuard,
  FormErrorsModule,
  IconModule, OrderConfirmationGuard, OrderConfirmationModule,
  OrderOverviewModule,
  PromotionsModule, PwaModule, ScheduleReplenishmentOrderModule,
  ShippingAddressModule,
  SpinnerModule
} from '@spartacus/storefront';
import {NgSelectModule} from '@ng-select/ng-select';
import {CommonModule} from '@angular/common';
import {BraintreeCoreModule} from 'braintree-spartacus-core';
import {braintreeTranslationChunksConfig, braintreeTranslations} from './translations';
import {BraintreeCheckoutConfig} from './config/braintree-checkout-config';
import {BraintreeOrderConfirmationThankYouMessageComponent} from './components/order/braintree-order-confirmation-thank-you-message/braintree-order-confirmation-thank-you-message.component';

const staticRoutes: Routes =
    [{
      path: 'localPaymentMethods/fallback',
      component: LPMFallbackComponent,
      data: {pageLabel: 'order'},
      canActivate: [CmsPageGuard],
    }];

@NgModule({
  declarations: [
    BraintreeCartComponent,
    BraintreePaymentMethodComponent,
    BraintreeCartTotalsComponent,
    BraintreeHostedFieldsComponent,
    LPMFallbackComponent,
    BraintreePaymentMethodsMyaccountComponent,
    BraintreeAddPaymentMethodMyaccountComponent,
    BraintreeMyaccountDropInComponent,
    BraintreeSelectAddressMyaccountComponent,
    BraintreeAddressComponent,
    BraintreeReviewOrderComponent,
    BraintreePaymentInfoComponent,
    BraintreeOrderOverviewComponent,
    BraintreeOrderDetailShippingComponent,
    BraintreeOrderConfirmationComponent,
    BraintreeBillingComponent,
    PaypalCreditMessageComponent,
    BraintreeReplenishmentOrderComponent,
    BraintreeOrderConfirmationThankYouMessageComponent,
    BraintreeDropInComponent,
    BraintreeCartDropInComponent
  ],
  imports: [
    BraintreeCoreModule,
    CommonModule,
    RouterModule.forChild(staticRoutes),
    ConfigModule.withConfig({
      cmsComponents: {
        OrderConfirmationThankMessageComponent: {
          component: BraintreeOrderConfirmationThankYouMessageComponent,
          guards: [OrderConfirmationGuard],
        },
        ReplenishmentConfirmationMessageComponent: {
          component: BraintreeOrderConfirmationThankYouMessageComponent,
          guards: [OrderConfirmationGuard],
        },
        OrderConfirmationOverviewComponent: {
          component: BraintreeOrderConfirmationComponent,
          guards: [OrderConfirmationGuard],
        },
        ReplenishmentConfirmationOverviewComponent: {
          component: BraintreeOrderConfirmationComponent,
          guards: [OrderConfirmationGuard],
        },
        PayPalCreditMessageComponentSPA: {
          component: PaypalCreditMessageComponent
        },
        AccountPaymentDetailsComponent: {
          component: BraintreePaymentMethodsMyaccountComponent
        },
        CheckoutPaymentDetails: {
          component: BraintreeBillingComponent
        },
        CheckoutReviewOrder: {
          component: BraintreeReviewOrderComponent
        },
        CartTotalsComponent: {
          component: BraintreeCartTotalsComponent
        },
        CheckoutScheduleReplenishmentOrder: {
          component: BraintreeReplenishmentOrderComponent,
          guards: [CheckoutAuthGuard, CartNotEmptyGuard],
        },
        ReplenishmentDetailShippingComponent: {
          component: BraintreeOrderDetailShippingComponent,
        },
        OrderApprovalDetailShippingComponent: {
          component: BraintreeOrderDetailShippingComponent,
        },
        AccountOrderDetailsShippingComponent: {
          component: BraintreeOrderDetailShippingComponent,
        },
      }
    } as CmsConfig),
    B2cStorefrontModule.withConfig({
      i18n: {
        resources: braintreeTranslations,
        chunks: braintreeTranslationChunksConfig,
        fallbackLang: 'en',
      }
    }),
    FormsModule,
    I18nModule,
    UrlModule,
    CardModule,
    IconModule,
    PromotionsModule,
    CartSharedModule,
    FormErrorsModule,
    NgSelectModule,
    ShippingAddressModule,
    AddressFormModule,
    AddressBookModule,
    ReactiveFormsModule,
    OrderOverviewModule,
    SpinnerModule,
    PwaModule,
    OrderConfirmationModule,
    ScheduleReplenishmentOrderModule
  ],
  entryComponents: [BraintreePaymentMethodComponent, BraintreeReviewOrderComponent, BraintreeDropInComponent],
  exports: [BraintreePaymentMethodComponent, BraintreeReviewOrderComponent, PaypalCreditMessageComponent, BraintreeDropInComponent],
})
export class BraintreeStorefrontModule {
  static withConfig(
      config?: BraintreeCheckoutConfig
  ): ModuleWithProviders<BraintreeStorefrontModule> {
    return {
      ngModule: BraintreeStorefrontModule,
      providers: [provideConfig(config)],
    };
  }
}
