import {NgModule} from '@angular/core';
import {BraintreePaymentAdapter} from './adapters/braintree-payment.adapter';
import {BraintreeCheckoutAdapter, PaymentAdapter, PaymentDetailsAdapter} from '../braintree-checkout/connectors';
import {BraintreePaymentDetailsAdapter} from './adapters/braintree-payment-details.adapter';
import {OccModule, UserPaymentAdapter} from '@spartacus/core';
import {BraintreeUserPaymentAdapter} from './adapters/braintree-user-payment.adapter';
import {DefaultBraintreeCheckoutAdapter} from './adapters/default-braintree-checkout.adapter';


@NgModule({
  declarations: [],
  providers: [
    {
      provide: PaymentAdapter,
      useClass: BraintreePaymentAdapter,
    },
    {
      provide: PaymentDetailsAdapter,
      useClass: BraintreePaymentDetailsAdapter,
    },
    {
      provide: UserPaymentAdapter,
      useClass: BraintreeUserPaymentAdapter,
    },
    {
      provide: BraintreeCheckoutAdapter,
      useClass: DefaultBraintreeCheckoutAdapter,
    }
    ],
  imports: [
      OccModule
  ]
})
export class BraintreeOccModule { }
