import {Injectable} from '@angular/core';
import {EventService, PaymentDetails} from '@spartacus/core';
import {BraintreeCheckoutPaymentService} from './braintree-checkout-payment.service';
import {CreatedAndSetBraintreePaymentDetailsEvent} from '../../events/braintree-payment-details.event';

@Injectable({
  providedIn: 'root'
})
export class BraintreeMarkCheckoutService {

  constructor(
    protected braintreeCheckoutPaymentService: BraintreeCheckoutPaymentService,
    protected eventService: EventService,
  ) {}

  processCheckout(paymentDetails: PaymentDetails): void{
    this.braintreeCheckoutPaymentService.setPaymentDetailsMarkCheckout(paymentDetails)
        .subscribe(() => {
            this.eventService.dispatch(new CreatedAndSetBraintreePaymentDetailsEvent());
        });
  }

}
