import {BraintreePaymentDetails} from '../models/braintree-payment-data.model';
import {
  ApplePayPaymentRequest,
  BraintreeCreditCardPaymentDetails,
  Fields,
  GooglePayPaymentRequest,
  LocalPaymentRequest, PageType,
  PayPalPaymentRequest,
  SrcPaymentRequest,
  VenmoPaymentData
} from '../models/braintree-payment-methods.model';
import {Observable} from 'rxjs';
import {Occ, Order} from '@spartacus/core';
import PaymentDetails = Occ.PaymentDetails;

export abstract class PaymentDetailsAdapter{

  abstract saveVenmoPaymentDetails(
    userId: string,
    selectedAddressCode: string,
    venmoPayment: VenmoPaymentData,
    cartId?: string,
    shouldBeSaved?: boolean,
    deviceData?: string,
    fields?: string
  ): Observable<PaymentDetails>;

  abstract savePayPalPaymentDetails(
    credit: boolean,
    payPalRequest: PayPalPaymentRequest,
    pageType: PageType,
    userId: string,
    cartId?: string,
    shouldBeSaved?: boolean,
    deviceData?: string,
    fields?: Fields,
    fundingSource?: string
  ): Observable<PaymentDetails>;

  abstract saveGooglePayPaymentDetails(
    userId: string,
    googlePayRequest: GooglePayPaymentRequest,
    shouldBeSaved: boolean,
    cartId?: string,
    deviceData?: string,
    fields?: Fields
  ): Observable<PaymentDetails>;

  abstract saveSrcPaymentDetails(
      userId: string,
      srcRequest: SrcPaymentRequest,
      shouldBeSaved: boolean,
      cartId?: string,
      deviceData?: string,
      fields?: Fields
  ): Observable<PaymentDetails>;

  abstract saveCreditCardPaymentDetails(
    userId: string,
    paymentDetails: BraintreeCreditCardPaymentDetails,
    selectedAddressCode: string,
    cartId?: string,
    shouldBeSaved?: boolean,
    deviceData?: string,
    fields?: Fields
  ): Observable<PaymentDetails>;

  abstract saveApplePayPaymentDetails(
    userId: string,
    applePayRequest: ApplePayPaymentRequest,
    cartId?: string,
    deviceData?: string,
    fields?: Fields
  ): Observable<PaymentDetails>;

  abstract processLocalPayment(
    userId: string,
    cartId: string,
    localPaymentRequest: LocalPaymentRequest,
    deviceData?: string,
    fields?: Fields
  ): Observable<Order>;

  abstract savePaymentIdForLPM(
    userId: string,
    cartId: string,
    paymentId: string
  ): Observable<{}>;

  abstract processLPMFallback(
    localPaymentRequest: LocalPaymentRequest,
    currencyFromFallbackURL: string,
    deviceData?: string,
    fields?: Fields,
  ): Observable<Order>;

  abstract getBraintreePaymentDetails(
    userId: string,
    saved: boolean,
    fields?: Fields
  ): Observable<BraintreePaymentDetails[]>;

  abstract getBraintreePaymentDetailsById(
    userId: string,
    paymentId: string,
    fields?: Fields
  ): Observable<BraintreePaymentDetails>;

  abstract selectBraintreePaymentMethod(
    userId: string,
    cartId: string,
    selectedPaymentMethodId: string,
    selectedPaymentMethodNonce: string
  ): Observable<{}>;
}
