import {Observable} from 'rxjs';
import {Address} from '@spartacus/core';
import {PriceValueData} from '../models';

export abstract class BraintreeCheckoutAdapter {

  abstract proceedExpressCheckout(
      paymentDetailsId: string,
      userId: string,
      cartId: string,
      address: Address
  ): Observable<boolean>;

  abstract countDeliveryPrice(
      countryCode: string,
      userId: string,
      cartId: string
  ): Observable<PriceValueData>;

}
