import {Injectable} from '@angular/core';
import {Converter} from '@spartacus/core';
import {VenmoPaymentData} from '../../models';
import {BraintreeOcc} from '../../../braintree-occ/models/occ-payment-method.model';

@Injectable({
  providedIn: 'root'
})
export class VenmoPaymentDetailsSerializer implements Converter<VenmoPaymentData, BraintreeOcc.VenmoPaymentData>{

  convert(source: VenmoPaymentData, target?: BraintreeOcc.VenmoPaymentData): BraintreeOcc.VenmoPaymentData {

    if (target === undefined) {
      target = {};
    }
    target.username = source.details.username;
    target.nonce = source.nonce;
    target.type = source.type;
    return target;
  }


}
