import {Injectable} from '@angular/core';
import {Address, Converter} from '@spartacus/core';
import {SrcAddress} from '../../models/braintree-payment-methods.model';

@Injectable({
  providedIn: 'root'
})
export class SrcAddressSerializer implements Converter<SrcAddress, Address> {

  convert(source: SrcAddress, target?: Address): Address {
    if (target === undefined) {
      target = {};
    }
    target.country = {
      isocode: source.countryCode
    };

    if (source.region) {
      target.region = {
        isocode: source.countryCode + '-' + source.region
      };
    }

    target.firstName = source.firstName;
    target.lastName = source.lastName;
    target.town = source.locality;
    target.line1 = source.streetAddress;
    target.phone = source.phoneNumber;
    target.postalCode = source.postalCode;

    return target;
  }
}
