import {Injectable} from '@angular/core';
import {Address, Converter} from '@spartacus/core';
import {PayPalTokenizePayload} from 'braintree-web';

@Injectable({
  providedIn: 'root'
})
export class PaypalAddressSerializer implements Converter<PayPalTokenizePayload, Address> {

  convert(source: PayPalTokenizePayload, target?: Address): Address {


    if (target === undefined) {
      target = {};
    }
    target.country = {
      isocode: source.details.shippingAddress.countryCode
    };

    if (source.details.shippingAddress.state) {
      target.region = {
        isocode: source.details.shippingAddress.countryCode + '-' + source.details.shippingAddress.state
      };
    }
    const recipientName = source.details.shippingAddress.recipientName.split(' ', 2);
    target.firstName = recipientName[0];
    target.lastName = recipientName[1];
    target.town = source.details.shippingAddress.city;
    target.line1 = source.details.shippingAddress.line1;
    target.line2 = source.details.shippingAddress.line2;
    target.phone = source.details.phone;
    target.postalCode = source.details.shippingAddress.postalCode;

    return target;
  }
}
