import {ApplePayAddress, SrcAddress, PriceValueData, SrcPaymentRequest, DropInButtonStyle} from '../../models';
import {InjectionToken} from '@angular/core';
import { Converter } from '@spartacus/core';
import {PayPalTokenizePayload} from 'braintree-web';
import {
  ApplePayPaymentRequest,
  BraintreeCreditCardPaymentDetails, BraintreePaymentDetails, CheckoutData, GooglePayAddress,
  GooglePayPaymentRequest, LocalPaymentRequest, PayPalButtonStyle,
  PayPalPaymentRequest,
  VenmoPaymentMethod
} from '../../models';

export const PAYPAL_ADDRESS_SERIALIZER = new InjectionToken<Converter<PayPalTokenizePayload, any>>(
  'PayPalAddressSerializer'
);

export const GOOGLE_PAY_ADDRESS_SERIALIZER = new InjectionToken<Converter<GooglePayAddress, any>>(
  'GooglePayAddressSerializer'
);

export const APPLE_PAY_ADDRESS_SERIALIZER = new InjectionToken<Converter<ApplePayAddress, any>>(
  'ApplePayAddressSerializer'
);

export const SRC_ADDRESS_SERIALIZER = new InjectionToken<Converter<SrcAddress, any>>(
    'SrcAddressSerializer'
);

export const VENMO_PAYMENT_DETAILS_SERIALIZER = new InjectionToken<
  Converter<VenmoPaymentMethod, any>
  >('VenmoPaymentMethodSerializer');

export const PAYPAL_PAYMENT_DETAILS_SERIALIZER = new InjectionToken<
  Converter<PayPalPaymentRequest, any>
  >('PayPalPaymentMethodSerializer');

export const GOOGLE_PAY_PAYMENT_DETAILS_SERIALIZER = new InjectionToken<
  Converter<GooglePayPaymentRequest, any>
  >('GooglePayPaymentMethodSerializer');

export const SRC_PAYMENT_DETAILS_SERIALIZER = new InjectionToken<
    Converter<SrcPaymentRequest, any>
    >('SrcPaymentMethodSerializer');

export const CREDIT_CARD_PAYMENT_DETAILS_SERIALIZER = new InjectionToken<
  Converter<BraintreeCreditCardPaymentDetails, any>
  >('CreditCardPaymentMethodSerializer');

export const APPLE_PAY_PAYMENT_DETAILS_SERIALIZER = new InjectionToken<
  Converter<ApplePayPaymentRequest, any>
  >('ApplePayPaymentMethodSerializer');

export const LOCALE_PAYMENT_METHOD_PAYMENT_DETAILS_SERIALIZER = new InjectionToken<
  Converter<LocalPaymentRequest, any>
  >('LocalPaymentMethodPaymentMethodSerializer');

export const CHECKOUT_DATA_NORMALIZER = new InjectionToken<
  Converter<any, CheckoutData>
  >('CheckoutDataNormalizer');

export const PRICE_VALUE_DATA_NORMALIZER = new InjectionToken<
    Converter<any, PriceValueData>
    >('PriceValueDataNormalizer');

export const BUTTON_STYLE_NORMALIZER = new InjectionToken<
  Converter<any, PayPalButtonStyle>
  >('ButtonStyleNormalizer');

export const DROP_IN_STYLE_NORMALIZER = new InjectionToken<
    Converter<any, DropInButtonStyle>
    >('DropInStyleNormalizer');

export const BRAINTREE_PAYMENT_DETAILS_NORMALIZER = new InjectionToken<
  Converter<any, BraintreePaymentDetails>
  >('BraintreePaymentDetailsNormalizer');
