import {PaymentDetails, PLACED_ORDER_PROCESS_ID, StateUtils} from '@spartacus/core';
import {
    ApplePayPaymentRequest,
    BraintreeCreditCardPaymentDetails,
    Fields,
    GooglePayPaymentRequest,
    LocalPaymentRequest, PageType,
    PayPalPaymentRequest, SrcPaymentRequest,
    VenmoPaymentData
} from '../../models/braintree-payment-methods.model';
import {Action} from '@ngrx/store';

export const CREATE_VENMO_PAYMENT_DETAILS = 'Create Venmo Payment Details';
export const CREATE_PAYPAL_PAYMENT_DETAILS = 'Create PatPal Payment Details';
export const CREATE_GOOGLE_PAY_PAYMENT_DETAILS = 'Create Google Pay Payment Details';
export const CREATE_SRC_PAYMENT_DETAILS = 'Create SRC Payment Details';
export const CREATE_CREDIT_CARD_PAYMENT_DETAILS = 'Create Credit Card Details';
export const CREATE_APPLE_PAY_PAYMENT_DETAILS = 'Create Apple Pay Details';
export const PROCESS_LOCAL_PAYMENT_METHOD = 'Create Locale Payments Payment Details';
export const PLACE_ORDER_THROUGH_FALLBACK = 'Place Order Through Fallback';
export const BRAINTREE_SELECTED_PAYMENT_DETAILS = 'Selected payment details';
export const SET_PAYMENT_DETAILS_PROCESS_ID = 'setPaymentDetails';
export const BRAINTREE_CREATE_PAYMENT_DETAILS_SUCCESS = 'Create Braintree Payment Details Success';

export const BRAINTREE_PROCESS_FEATURE = 'process';

export class CreateVenmoPaymentDetails extends StateUtils.EntityLoadAction {
  readonly type = CREATE_VENMO_PAYMENT_DETAILS;
  constructor(
    public payload: {
      userId: string,
      selectedAddressCode: string,
      venmoPayment: VenmoPaymentData,
      cartId?: string;
      shouldBeSaved?: boolean,
      deviceData?: string,
      fields?: Fields
    }
  ) {
    super(BRAINTREE_PROCESS_FEATURE, SET_PAYMENT_DETAILS_PROCESS_ID);
  }
}

export class CreatePayPalPaymentDetails extends StateUtils.EntityLoadAction {
  readonly type = CREATE_PAYPAL_PAYMENT_DETAILS;
  constructor(
    public payload: {
      credit: boolean,
      shouldBeSaved: boolean,
      payPalRequest: PayPalPaymentRequest,
      pageType: PageType,
      userId: string,
      cartId?: string,
      deviceData?: string,
      fields?: Fields,
      fundingSource?: string
    }
  ) {
    super(BRAINTREE_PROCESS_FEATURE, SET_PAYMENT_DETAILS_PROCESS_ID);
  }
}

export class CreateGooglePayPaymentDetails extends StateUtils.EntityLoadAction {
  readonly type = CREATE_GOOGLE_PAY_PAYMENT_DETAILS;
  constructor(
    public payload: {
      userId: string,
      googlePayRequest: GooglePayPaymentRequest,
      shouldBeSaved: boolean,
      cartId?: string,
      deviceData?: string,
      fields?: Fields
    }
  ) {
    super(BRAINTREE_PROCESS_FEATURE, SET_PAYMENT_DETAILS_PROCESS_ID);
  }
}

export class CreateSrcPaymentDetails extends StateUtils.EntityLoadAction {
  readonly type = CREATE_SRC_PAYMENT_DETAILS;
  constructor(
      public payload: {
        userId: string,
        srcRequest: SrcPaymentRequest,
        shouldBeSaved: boolean,
        cartId?: string,
        deviceData?: string,
        fields?: Fields
      }
  ) {
    super(BRAINTREE_PROCESS_FEATURE, SET_PAYMENT_DETAILS_PROCESS_ID);
  }
}

export class CreateCreditCardPaymentDetails extends StateUtils.EntityLoadAction {
  readonly type = CREATE_CREDIT_CARD_PAYMENT_DETAILS;
  constructor(
    public payload: {
      userId: string,
      paymentDetails: BraintreeCreditCardPaymentDetails,
      selectedAddressCode: string,
      cartId?: string,
      shouldBeSaved?: boolean,
      deviceData?: string,
      fields?: Fields
    }
  ) {
    super(BRAINTREE_PROCESS_FEATURE, SET_PAYMENT_DETAILS_PROCESS_ID);
  }
}

export class CreateApplePayPaymentDetails extends StateUtils.EntityLoadAction {
  readonly type = CREATE_APPLE_PAY_PAYMENT_DETAILS;
  constructor(
    public payload: {
      userId: string,
      applePayRequest: ApplePayPaymentRequest,
      cartId?: string,
      deviceData?: string,
      fields?: Fields
    }
  ) {
    super(BRAINTREE_PROCESS_FEATURE, SET_PAYMENT_DETAILS_PROCESS_ID);
  }
}

export class ProcessLocalPaymentMethod extends StateUtils.EntityLoadAction {
  readonly type = PROCESS_LOCAL_PAYMENT_METHOD;
  constructor(
    public payload: {
      userId: string,
      cartId: string,
      localPaymentRequest: LocalPaymentRequest,
      deviceData?: string,
      fields?: Fields
    }
  ) {
    super(BRAINTREE_PROCESS_FEATURE, PLACED_ORDER_PROCESS_ID);
  }
}

export class PlaceOrderThroughFallback extends StateUtils.EntityLoadAction {
  readonly type = PLACE_ORDER_THROUGH_FALLBACK;
  constructor(
    public payload: {
      localPaymentRequest: LocalPaymentRequest,
        currencyFromFallbackURL: string,
      deviceData?: string,
      fields?: Fields,
      cartId?: string
    }
  ) {
    super(BRAINTREE_PROCESS_FEATURE, PLACED_ORDER_PROCESS_ID);
  }
}

export class BraintreeCreatePaymentDetailsSuccess implements Action {
  readonly type = BRAINTREE_CREATE_PAYMENT_DETAILS_SUCCESS;
  constructor(public payload: PaymentDetails) {}
}

export class BraintreeSelectedPaymentDetails extends StateUtils.EntitySuccessAction {
  readonly type = BRAINTREE_SELECTED_PAYMENT_DETAILS;
  constructor() {
    super(BRAINTREE_PROCESS_FEATURE, SET_PAYMENT_DETAILS_PROCESS_ID);
  }
}

export type BraintreeCreatePaymentDetailsAction =
  | CreateVenmoPaymentDetails
  | BraintreeCreatePaymentDetailsSuccess
  | CreatePayPalPaymentDetails
  | CreateGooglePayPaymentDetails
  | CreateSrcPaymentDetails
  | CreateCreditCardPaymentDetails
  | CreateApplePayPaymentDetails
  | ProcessLocalPaymentMethod;
