package com.paypal.services.impl;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.config.ConfigurationService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.apache.commons.configuration.Configuration;

import static com.paypal.constants.PaypalwebservicesConstants.PAYPAL_WEBHOOK_ID;
import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalWebservicesConfigurationServiceTest {

    private static final String EVENT_TYPE = "eventtype";

    @Mock
    private ConfigurationService configurationService;
    @Mock
    private Configuration configuration;

    @InjectMocks
    private DefaultPayPalWebservicesConfigurationService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void getWebhookId() {
        when(configurationService.getConfiguration()).thenReturn(configuration);
        when(configuration.getString(PAYPAL_WEBHOOK_ID + EVENT_TYPE))
                .thenReturn(PAYPAL_WEBHOOK_ID + EVENT_TYPE);

        String result = unit.getWebhookId(EVENT_TYPE);

        assertEquals(PAYPAL_WEBHOOK_ID + EVENT_TYPE, result);
    }

}