/*

 */
package com.paypal.paypalspartacusdata.setup.impl;

import de.hybris.platform.addonsupport.setup.impl.DefaultAddonSampleDataImportService;
import de.hybris.platform.core.initialization.SystemSetupContext;
import java.util.ArrayList;
import java.util.List;

public class PayPalSpaSampleDataImportService extends DefaultAddonSampleDataImportService
{
    List<String> catalogs;

    /**
     * Default constructor
     */
    public PayPalSpaSampleDataImportService() {
        catalogs = new ArrayList<>();
        catalogs.add("electronics");
        catalogs.add("apparel-uk");
        catalogs.add("powertools");
        catalogs.add("electronics-spa");
        catalogs.add("apparel-uk-spa");
        catalogs.add("powertools-spa");
    }

    @Override
    protected void importContentCatalog(SystemSetupContext context, String importRoot, String catalogName)
    {
        logInfo(context, "PayPalSpartacusData - Begin synchronizing Content Catalog [" + catalogName + "] - synchronizing");
        if (catalogs.contains(catalogName))
        {
            importImpexFile(context, importRoot + "/contentCatalogs/" + catalogName + "ContentCatalog/cms-responsive-content.impex", true);
            importImpexFile(context, importRoot + "/contentCatalogs/" + catalogName + "ContentCatalog/email-content.impex", true);
            synchronizeContentCatalog(context, catalogName + "-spa", true);
        }
        logInfo(context, "PayPalSpartacusData - Finished synchronizing Content Catalog [" + catalogName + "] - synchronizing");

    }

    @Override
    protected void importStoreInitialData(SystemSetupContext context, String importRoot,
                                          List<String> storeNames, String productCatalog,
                                          List<String> contentCatalogs, boolean solrReindex) {
        storeNames.forEach(store -> importPayPalPluginConfiguration(context, importRoot, store));
    }

    private void importPayPalPluginConfiguration(SystemSetupContext context, String importRoot, String storeName) {
        logInfo(context, "PayPalSpartacusData - Importing PayPal plugin configuration for base store [" + storeName + "]");

        importImpexFile(context, importRoot + "/configuration/" + storeName + "/paypal-plugin-configuration.impex", true);

        logInfo(context, "PayPalSpartacusData - Finished importing PayPal plugin configuration for base store [" + storeName + "]");
    }

}
