package com.paypal.service.impl;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.catalog.model.CatalogUnawareMediaModel;
import de.hybris.platform.core.model.media.MediaModel;
import de.hybris.platform.servicelayer.exceptions.SystemException;
import de.hybris.platform.servicelayer.media.MediaService;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;


import static de.hybris.platform.testframework.Assert.assertEquals;
import static org.mockito.Matchers.any;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPaypalfulfilmentprocessServiceTest {

    private static final String LOGO_CODE = "logo code";
    private static final String MEDIA_URL = "media url";
    private static final String SAP_HYBRIS_PLATFORM_PNG = "sap-hybris-platform.png";
    private static final String MEDIA_CODE = "media code";

    private static final String FIND_LOGO_QUERY = "SELECT {" + CatalogUnawareMediaModel.PK + "} FROM {"
            + CatalogUnawareMediaModel._TYPECODE + "} WHERE {" + CatalogUnawareMediaModel.CODE + "}=?code";
    private static final String CODE = "code";
    @InjectMocks
    private DefaultPaypalfulfilmentprocessService paypalfulfilmentprocessService;

    @Mock
    private MediaService mediaService;
    @Mock
    private ModelService modelService;
    @Mock
    private FlexibleSearchService flexibleSearchService;

    @Mock
    private MediaModel mockMedia;
    @Mock
    private CatalogUnawareMediaModel mockCatalogUnawareMedia;
    @Captor
    private ArgumentCaptor<FlexibleSearchQuery> flexibleSearchQueryArgumentCaptor;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        when(mockMedia.getCode()).thenReturn(MEDIA_CODE);
        when(mediaService.getMedia(LOGO_CODE)).thenReturn(mockMedia);
        when(mockMedia.getURL()).thenReturn(MEDIA_URL);
        when(modelService.create(CatalogUnawareMediaModel.class)).thenReturn(mockCatalogUnawareMedia);
    }

    @Test
    public void shouldGetHybrisLogoUrlByCode() {
        String actual = paypalfulfilmentprocessService.getHybrisLogoUrl(LOGO_CODE);

        assertEquals(MEDIA_URL, actual);
    }

    @Test
    public void shouldUseSavedLogoWhenItExists() {
        when(flexibleSearchService.searchUnique(any())).thenReturn(mockCatalogUnawareMedia);

        paypalfulfilmentprocessService.createLogo(LOGO_CODE);

        verify(modelService, never()).create(CatalogUnawareMediaModel.class);
        verify(mockCatalogUnawareMedia).setCode(LOGO_CODE);
        verify(mockCatalogUnawareMedia).setRealFileName(SAP_HYBRIS_PLATFORM_PNG);
        verify(mediaService).setStreamForMedia(eq(mockCatalogUnawareMedia), any());
    }

    @Test
    public void shouldCreateNewLogoWhenItIsNotSaved() {
        when(flexibleSearchService.searchUnique(any())).thenReturn(null);

        paypalfulfilmentprocessService.createLogo(LOGO_CODE);

        verify(mediaService).setStreamForMedia(eq(mockCatalogUnawareMedia), any());
        verify(mockCatalogUnawareMedia).setCode(LOGO_CODE);
        verify(mockCatalogUnawareMedia).setRealFileName(SAP_HYBRIS_PLATFORM_PNG);
    }

    @Test
    public void shouldCreateNewLogoWhenFlexibleQueryFailed() {
        when(flexibleSearchService.searchUnique(any())).thenThrow(SystemException.class);

        paypalfulfilmentprocessService.createLogo(LOGO_CODE);

        verify(mediaService).setStreamForMedia(eq(mockCatalogUnawareMedia), any());
        verify(mockCatalogUnawareMedia).setCode(LOGO_CODE);
        verify(mockCatalogUnawareMedia).setRealFileName(SAP_HYBRIS_PLATFORM_PNG);

        verify(flexibleSearchService).searchUnique(flexibleSearchQueryArgumentCaptor.capture());
        FlexibleSearchQuery query = flexibleSearchQueryArgumentCaptor.getValue();
        assertEquals(LOGO_CODE, query.getQueryParameters().get(CODE));
        assertEquals(FIND_LOGO_QUERY, query.getQuery());
    }


}
