package com.paypal.action;

import com.paypal.hybris.core.service.PayPalPaymentInfoService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.processengine.action.AbstractSimpleDecisionAction.Transition;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

import java.util.Collections;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

@UnitTest
@RunWith(MockitoJUnitRunner.StrictStubs.class)
public class PayPalCheckAuthorizeOrderPaymentActionTest {

    @Mock
    private PayPalPaymentInfoService paymentInfoService;
    @Mock
    private OrderModel orderModel;
    @Mock
    private PaymentInfoModel paymentInfoModel;
    @InjectMocks
    private PayPalCheckAuthorizeOrderPaymentAction unit;

    @Before
    public void setUp() {
        when(orderModel.getPaymentInfo()).thenReturn(paymentInfoModel);
    }

    @Test
    public void shouldReturnTransitionOkWhenSaveOrderFlowActiveAndTransactionsAreEmpty() {
        when(paymentInfoService.isPayPalSaveOrderFlowActive(paymentInfoModel)).thenReturn(true);
        when(orderModel.getPaymentTransactions()).thenReturn(Collections.emptyList());

        Transition transition = unit.assignStatusForOrder(orderModel);

        assertEquals(Transition.OK, transition);
    }

}
