package com.paypal.action;

import com.paypal.hybris.core.service.PayPalPaymentInfoService;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.yacceleratorfulfilmentprocess.actions.order.CheckAuthorizeOrderPaymentAction;


public class PayPalCheckAuthorizeOrderPaymentAction extends CheckAuthorizeOrderPaymentAction {

    private PayPalPaymentInfoService paymentInfoService;

    @Override
    protected Transition assignStatusForOrder(OrderModel order) {
        if (paymentInfoService.isPayPalSaveOrderFlowActive(order.getPaymentInfo())
                && order.getPaymentTransactions().isEmpty()) {
            return Transition.OK;
        }

        return super.assignStatusForOrder(order);
    }

    public void setPaymentInfoService(PayPalPaymentInfoService paymentInfoService) {
        this.paymentInfoService = paymentInfoService;
    }

}
