package com.paypal.hybris.facade.strategy.configuration.page.impl;

import com.paypal.enums.PayPalPageType;
import com.paypal.hybris.data.PayPalEssentialConfigurationData;
import com.paypal.hybris.data.PayPalPluginConfigurationData;
import com.paypal.hybris.data.PaypalGeneralPageConfigurationData;
import com.paypal.hybris.facade.facades.PayPalConfigurationFacade;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.catalog.CatalogVersionService;
import de.hybris.platform.servicelayer.i18n.I18NService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Collections;
import java.util.Currency;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class MiniCartPageConfigurationStrategyTest {

    private static final String CURRENCY_CODE_VALUE = "USD";

    @Mock
    private CatalogVersionService catalogVersionService;
    @Mock
    private PayPalConfigurationFacade payPalConfigurationFacade;
    @Mock
    private I18NService i18NService;

    @InjectMocks
    private MiniCartPageConfigurationStrategy unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetConfiguration() {
        when(catalogVersionService.getSessionCatalogVersions()).thenReturn(Collections.emptyList());
        when(payPalConfigurationFacade.getPayPalPluginConfigurationData()).thenReturn(new PayPalPluginConfigurationData());
        when(payPalConfigurationFacade.getPayPalEssentialConfigurationData()).thenReturn(new PayPalEssentialConfigurationData());
        when(i18NService.getCurrentJavaCurrency()).thenReturn(Currency.getInstance(CURRENCY_CODE_VALUE));

        PaypalGeneralPageConfigurationData result = unit.getConfiguration();

        assertNull(result.getPaypalPageSpecificConfiguration().getVenmoIconUrl());
        assertEquals(CURRENCY_CODE_VALUE, result.getPaypalPageSpecificConfiguration().getCurrency());
    }

    @Test
    public void shouldReturnTrueWhenPageTypeIsMinicart() {
        boolean result = unit.test(PayPalPageType.MINICART);
        assertTrue(result);
    }

}