package com.paypal.hybris.facade.strategy.configuration.page.impl;

import com.paypal.enums.PayPalPageType;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.data.PayPalEssentialConfigurationData;
import com.paypal.hybris.data.PayPalPluginConfigurationData;
import com.paypal.hybris.data.PaypalGeneralPageConfigurationData;
import com.paypal.hybris.facade.facades.PayPalClientTokenFacade;
import com.paypal.hybris.facade.facades.PayPalConfigurationFacade;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.catalog.CatalogVersionService;
import de.hybris.platform.servicelayer.i18n.I18NService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Collections;
import java.util.Currency;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class MarkPageConfigurationStrategyTest {

    private static final String CURRENCY_CODE_VALUE = "USD";
    private static final String CLIENT_TOKEN_VALUE = "token";

    @Mock
    private CatalogVersionService catalogVersionService;
    @Mock
    private PayPalConfigurationFacade payPalConfigurationFacade;
    @Mock
    private I18NService i18NService;
    @Mock
    private PayPalConfigurationService payPalConfigurationService;
    @Mock
    private PayPalClientTokenFacade payPalClientTokenFacade;

    @InjectMocks
    private MarkPageConfigurationStrategy unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        when(catalogVersionService.getSessionCatalogVersions()).thenReturn(Collections.emptyList());
        when(payPalConfigurationFacade.getPayPalPluginConfigurationData()).thenReturn(new PayPalPluginConfigurationData());
        when(payPalConfigurationFacade.getPayPalEssentialConfigurationData()).thenReturn(new PayPalEssentialConfigurationData());
        when(i18NService.getCurrentJavaCurrency()).thenReturn(Currency.getInstance(CURRENCY_CODE_VALUE));
        when(payPalConfigurationService.isPayPalHostedFieldsEnabled()).thenReturn(true);
    }

    @Test
    public void shouldGetConfiguration() {
        when(payPalClientTokenFacade.getClientToken()).thenReturn(CLIENT_TOKEN_VALUE);

        PaypalGeneralPageConfigurationData result = unit.getConfiguration();

        assertEquals(CLIENT_TOKEN_VALUE, result.getPaypalPageSpecificConfiguration().getClientToken());
    }

    @Test
    public void shouldNotSetClientTokenWhenHostedFieldsDisabled() {
        when(payPalConfigurationService.isPayPalHostedFieldsEnabled()).thenReturn(false);

        unit.getConfiguration();

        verify(payPalClientTokenFacade, times(0)).getClientToken();
    }

    @Test
    public void shouldReturnTrueWhenPageTypeIsMark() {
        boolean result = unit.test(PayPalPageType.MARK);
        assertTrue(result);
    }

}