package com.paypal.hybris.facade.strategy.configuration.page.impl;

import com.paypal.enums.PayPalPageType;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.data.PayPalEssentialConfigurationData;
import com.paypal.hybris.data.PayPalPluginConfigurationData;
import com.paypal.hybris.data.PaypalGeneralPageConfigurationData;
import com.paypal.hybris.facade.facades.PayPalConfigurationFacade;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.catalog.CatalogVersionService;
import de.hybris.platform.servicelayer.i18n.I18NService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Collections;
import java.util.Currency;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class LoginPageConfigurationStrategyTest {

    private static final String CURRENCY_CODE_VALUE = "USD";
    private static final String CONNECT_SCOPES = "email profile address https\\://uri.paypal.com/services/paypalattributes";
    private static final String CONNECT_RESPONSE_TYPE = "code";
    private static final String CONNECT_RETURN_URL = "returnUrl";
    private static final String CONNECT_SCRIPT = "https\\://www.paypalobjects.com/js/external/api.js";

    @Mock
    private CatalogVersionService catalogVersionService;
    @Mock
    private PayPalConfigurationFacade payPalConfigurationFacade;
    @Mock
    private I18NService i18NService;
    @Mock
    private PayPalConfigurationService payPalConfigurationService;

    @InjectMocks
    LoginPageConfigurationStrategy unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetConfiguration() {
        when(catalogVersionService.getSessionCatalogVersions()).thenReturn(Collections.emptyList());
        when(payPalConfigurationFacade.getPayPalPluginConfigurationData()).thenReturn(new PayPalPluginConfigurationData());
        when(payPalConfigurationFacade.getPayPalEssentialConfigurationData()).thenReturn(new PayPalEssentialConfigurationData());
        when(i18NService.getCurrentJavaCurrency()).thenReturn(Currency.getInstance(CURRENCY_CODE_VALUE));
        when(payPalConfigurationService.getPayPalConnectScopes()).thenReturn(CONNECT_SCOPES);
        when(payPalConfigurationService.getPayPalConnectResponseType()).thenReturn(CONNECT_RESPONSE_TYPE);
        when(payPalConfigurationService.getPayPalConnectReturnUrl()).thenReturn(CONNECT_RETURN_URL);
        when(payPalConfigurationService.getPayPalConnectScript()).thenReturn(CONNECT_SCRIPT);

        PaypalGeneralPageConfigurationData result = unit.getConfiguration();

        assertEquals(CONNECT_SCOPES, result.getPaypalPageSpecificConfiguration().getPayPalConnectScopes());
        assertEquals(CONNECT_RESPONSE_TYPE, result.getPaypalPageSpecificConfiguration().getPayPalConnectResponseType());
        assertEquals(CONNECT_RETURN_URL, result.getPaypalPageSpecificConfiguration().getPayPalConnectReturnUrl());
        assertEquals(CONNECT_SCRIPT, result.getPaypalPageSpecificConfiguration().getPayPalConnectScript());
    }

    @Test
    public void shouldReturnTrueWhenPageTypeIsLogin() {
        boolean result = unit.test(PayPalPageType.LOGIN);
        assertTrue(result);
    }

}