package com.paypal.hybris.facade.strategy.configuration.page.impl;

import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.data.PayPalEssentialConfigurationData;
import com.paypal.hybris.data.PayPalPluginConfigurationData;
import com.paypal.hybris.facade.facades.PayPalClientTokenFacade;
import com.paypal.hybris.facade.facades.PayPalConfigurationFacade;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.catalog.CatalogVersionService;
import de.hybris.platform.catalog.model.CatalogVersionModel;
import de.hybris.platform.core.model.media.MediaModel;
import de.hybris.platform.servicelayer.i18n.I18NService;
import de.hybris.platform.servicelayer.media.MediaService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Currency;
import java.util.List;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class BasePageConfigurationStrategyTest {

    private static final String CURRENCY_CODE_VALUE = "USD";
    private static final String VENMO_LOGO = "venmoLogo";
    private static final String APPLE_PAY_LOGO = "applePayLogo";
    private static final String DOWNLOAD_URL_VALUE = "url";

    @Mock
    private CatalogVersionService catalogVersionService;
    @Mock
    private PayPalConfigurationFacade payPalConfigurationFacade;
    @Mock
    private I18NService i18NService;
    @Mock
    private PayPalConfigurationService payPalConfigurationService;
    @Mock
    private PayPalClientTokenFacade payPalClientTokenFacade;
    @Mock
    private MediaService mediaService;
    @Mock
    private MediaModel mediaModel;
    @Mock
    private CatalogVersionModel catalogVersionModel;

    @InjectMocks
    BasePageConfigurationStrategy unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetPayPalGeneralPageConfiguration() {
        when(catalogVersionService.getSessionCatalogVersions()).thenReturn(List.of(catalogVersionModel));
        when(payPalConfigurationFacade.getPayPalPluginConfigurationData()).thenReturn(new PayPalPluginConfigurationData());
        when(payPalConfigurationFacade.getPayPalEssentialConfigurationData()).thenReturn(new PayPalEssentialConfigurationData());
        when(i18NService.getCurrentJavaCurrency()).thenReturn(Currency.getInstance(CURRENCY_CODE_VALUE));
        when(mediaService.getMedia(catalogVersionModel, VENMO_LOGO)).thenReturn(mediaModel);
        when(mediaService.getMedia(catalogVersionModel, APPLE_PAY_LOGO)).thenReturn(mediaModel);
        when(mediaModel.getDownloadURL()).thenReturn(DOWNLOAD_URL_VALUE);

        unit.getPayPalGeneralPageConfiguration();

        verify(mediaService).getMedia(catalogVersionModel, VENMO_LOGO);
    }

}