package com.paypal.hybris.facade.setup;

import com.paypal.hybris.core.service.PaypalLogoService;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static com.paypal.hybris.facade.constants.PaypalfacadesConstants.PLATFORM_LOGO_CODE;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.verify;

@UnitTest
public class PaypalfacadesSystemSetupTest {

    @Mock
    private PaypalLogoService paypalLogoService;

    @InjectMocks
    private PaypalfacadesSystemSetup unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldCreateEssentialData() {
        doNothing().when(paypalLogoService).createLogo(PLATFORM_LOGO_CODE);

        unit.createEssentialData();

        verify(paypalLogoService).createLogo(PLATFORM_LOGO_CODE);
    }

}