package com.paypal.hybris.facade.service.impl;

import com.paypal.hybris.core.enums.Location;
import com.paypal.hybris.core.model.ApplePayConfigurationModel;
import com.paypal.hybris.core.model.ApplePayStylesConfigurationModel;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;
import com.paypal.hybris.core.model.HostedFieldsStylesConfigurationModel;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import com.paypal.hybris.core.model.PayPalPluginConfigurationModel;
import com.paypal.hybris.core.model.PayPalStylesConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.store.BaseStoreModel;
import de.hybris.platform.store.services.BaseStoreService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultStylesConfigurationServiceTest {

    private AutoCloseable closeable;

    @Mock
    private BaseStoreService baseStoreService;
    @Mock
    private ModelService modelService;
    @Mock
    private BaseStoreModel baseStoreModel;
    @Mock
    private PayPalPluginConfigurationModel payPalPluginConfigurationModel;
    @Mock
    private HostedFieldsConfigurationModel hostedFieldsConfigurationModel;
    @Mock
    private HostedFieldsStylesConfigurationModel hostedFieldsStylesConfigurationModel;
    @Mock
    private PayPalConfigurationModel payPalConfigurationModel;
    @Mock
    private PayPalStylesConfigurationModel payPalStylesConfigurationModel;
    @Mock
    private ApplePayStylesConfigurationModel applePayStylesConfigurationModel;
    @Mock
    private ApplePayConfigurationModel applePayConfigurationModel;

    @InjectMocks
    @Spy
    private DefaultStylesConfigurationService unit;

    @Before
    public void initSetUp() {
        closeable = MockitoAnnotations.openMocks(this);

        when(baseStoreService.getCurrentBaseStore()).thenReturn(baseStoreModel);
        when(baseStoreModel.getPayPalPluginConfiguration()).thenReturn(payPalPluginConfigurationModel);

        when(payPalPluginConfigurationModel.getPayPalConfiguration()).thenReturn(payPalConfigurationModel);
        when(payPalPluginConfigurationModel.getHostedFieldsConfiguration()).thenReturn(hostedFieldsConfigurationModel);
        when(payPalPluginConfigurationModel.getApplePayConfiguration()).thenReturn(applePayConfigurationModel);

        when(payPalConfigurationModel.getPayPalStylesConfiguration()).thenReturn(List.of(payPalStylesConfigurationModel));
        when(payPalStylesConfigurationModel.getLocation()).thenReturn(Location.MINICART);

        when(applePayConfigurationModel.getApplePayStylesConfiguration()).thenReturn(List.of(applePayStylesConfigurationModel));
        when(applePayStylesConfigurationModel.getLocation()).thenReturn(Location.MINICART);

        when(modelService.create(HostedFieldsStylesConfigurationModel.class)).thenReturn(hostedFieldsStylesConfigurationModel);
        when(modelService.create(PayPalStylesConfigurationModel.class)).thenReturn(payPalStylesConfigurationModel);
        when(modelService.create(ApplePayStylesConfigurationModel.class)).thenReturn(applePayStylesConfigurationModel);
    }

    @Test
    public void shouldGetHostedFieldsStylesConfiguration() {
        when(hostedFieldsConfigurationModel.getHostedFieldsStylesConfiguration())
                .thenReturn(hostedFieldsStylesConfigurationModel);

        HostedFieldsStylesConfigurationModel result = unit.getHostedFieldsStylesConfiguration();

        assertEquals(hostedFieldsStylesConfigurationModel, result);
    }

    @Test
    public void shouldReturnDefaultWhenHostedFieldsStylesConfigurationNotFound() {
        when(hostedFieldsConfigurationModel.getHostedFieldsStylesConfiguration())
                .thenReturn(null);

        HostedFieldsStylesConfigurationModel result = unit.getHostedFieldsStylesConfiguration();

        verify(modelService).create(HostedFieldsStylesConfigurationModel.class);
        assertEquals(hostedFieldsStylesConfigurationModel, result);
    }

    @Test
    public void shouldGetPayPalStylesConfiguration() {
        when(payPalStylesConfigurationModel.getLocation()).thenReturn(Location.MINICART);

        PayPalStylesConfigurationModel result = unit.getPayPalStylesConfiguration(Location.MINICART.name());

        assertEquals(payPalStylesConfigurationModel, result);
    }

    @Test
    public void shouldReturnDefaultWhenStyleConfigurationNotFound() {
        when(payPalStylesConfigurationModel.getLocation()).thenReturn(Location.MINICART);

        PayPalStylesConfigurationModel result = unit.getPayPalStylesConfiguration(Location.CART.name());
        verify(modelService).create(PayPalStylesConfigurationModel.class);
        assertEquals(payPalStylesConfigurationModel, result);
    }

    @Test
    public void shouldGetApplePayStylesConfiguration() {
        when(applePayStylesConfigurationModel.getLocation()).thenReturn(Location.MINICART);

        PayPalStylesConfigurationModel result = unit.getPayPalStylesConfiguration(Location.MINICART.name());

        assertEquals(payPalStylesConfigurationModel, result);
    }

    @Test
    public void shouldReturnDefaultWhenApplePayStyleConfigurationNotFound() {
        when(applePayStylesConfigurationModel.getLocation()).thenReturn(Location.MINICART);

        ApplePayStylesConfigurationModel result = unit.getApplePayStylesConfiguration(Location.CART.name());
        verify(modelService).create(ApplePayStylesConfigurationModel.class);
        assertEquals(applePayStylesConfigurationModel, result);
    }

    @After
    public void close() throws Exception {
        closeable.close();
    }

}