package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.model.VenmoConfigurationModel;
import com.paypal.hybris.data.VenmoConfigurationData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;


import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class VenmoConfigurationDataPopulatorTest {

    @Mock
    private VenmoConfigurationModel configurationModel;

    @InjectMocks
    private VenmoConfigurationDataPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldPopulateVenmoConfigurationData() {
        VenmoConfigurationData configurationData = new VenmoConfigurationData();

        when(configurationModel.isEnable()).thenReturn(true);

        unit.populate(configurationModel, configurationData);

        assertTrue(configurationData.isEnable());
    }

}