package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.enums.Location;
import com.paypal.hybris.core.enums.PayPalColor;
import com.paypal.hybris.core.enums.PayPalLabel;
import com.paypal.hybris.core.enums.PayPalShape;
import com.paypal.hybris.core.model.PayPalStylesConfigurationModel;
import com.paypal.hybris.data.PayPalStylesConfigurationData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalStylesConfigPopulatorTest {

    private static final int HEIGHT_VALUE = 15;
    private static final int BORDER_RADIUS = 12;

    @Mock
    private PayPalStylesConfigurationModel configurationModel;

    @InjectMocks
    private PayPalStylesConfigPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldPopulatePayPalStylesConfig() {
        PayPalStylesConfigurationData configurationData = new PayPalStylesConfigurationData();

        when(configurationModel.getLocation()).thenReturn(Location.MINICART);
        when(configurationModel.getColor()).thenReturn(PayPalColor.GOLD);
        when(configurationModel.getShape()).thenReturn(PayPalShape.RECT);
        when(configurationModel.getLabel()).thenReturn(PayPalLabel.PAYPAL);
        when(configurationModel.getHeight()).thenReturn(HEIGHT_VALUE);
        when(configurationModel.getBorderRadius()).thenReturn(BORDER_RADIUS);

        unit.populate(configurationModel, configurationData);

        assertEquals(Location.MINICART.getCode().toLowerCase(), configurationData.getLocation());
        assertEquals(PayPalColor.GOLD.getCode().toLowerCase(), configurationData.getColor());
        assertEquals(PayPalShape.RECT.getCode().toLowerCase(), configurationData.getShape());
        assertEquals(PayPalLabel.PAYPAL.getCode().toLowerCase(), configurationData.getLabel());
        assertEquals(HEIGHT_VALUE, configurationData.getHeight().intValue());
        assertEquals(BORDER_RADIUS, configurationData.getBorderRadius().intValue());
    }

}