package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.model.PayPalGeneralConfigurationModel;
import com.paypal.hybris.data.PayPalGeneralConfigurationData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_AUTHORIZE;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_CAPTURE;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalGeneralConfigurationDataPopulatorTest {

    private static final String BUYER_COUNTRY_VALUE = "bayerCountry";
    private static final String EN_LOCALE_VALUE = "en";

    @Mock
    private PayPalGeneralConfigurationModel configurationModel;

    PayPalGeneralConfigurationData configurationData;

    @InjectMocks
    PayPalGeneralConfigurationDataPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        configurationData = new PayPalGeneralConfigurationData();

        when(configurationModel.getBuyerCountry()).thenReturn(BUYER_COUNTRY_VALUE);
        when(configurationModel.isSettleImmediately()).thenReturn(true);
        when(configurationModel.isFraudNetIntegration()).thenReturn(true);
        when(configurationModel.isFraudNetSandbox()).thenReturn(true);
        when(configurationModel.getLocale()).thenReturn(EN_LOCALE_VALUE);
        when(configurationModel.isSettleImmediately()).thenReturn(false);
    }

    @Test
    public void shouldPopulatePayPalGeneralConfigurationData() {
        unit.populate(configurationModel, configurationData);

        assertEquals(BUYER_COUNTRY_VALUE, configurationData.getBuyerCountry());
        assertEquals(PAYPAL_INTENT_AUTHORIZE, configurationData.getPayPalIntent());
        assertTrue(configurationData.isFraudNetIntegration());
        assertTrue(configurationData.isFraudNetSandbox());
        assertEquals(EN_LOCALE_VALUE, configurationData.getLocale());
    }

    @Test
    public void shouldMapIntentToPaypalIntentCaptureWhenIsSettleImmediatelyIsTrue() {
        when(configurationModel.isSettleImmediately()).thenReturn(true);

        unit.populate(configurationModel, configurationData);

        assertEquals(PAYPAL_INTENT_CAPTURE, configurationData.getPayPalIntent());
    }

}