package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.enums.PayPalFunding;
import com.paypal.hybris.core.enums.SavedPaymentMethodsLimit;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import com.paypal.hybris.data.PayPalConfigurationData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Set;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalConfigurationDataPopulatorTest {

    @Mock
    private PayPalConfigurationModel configurationModel;

    @InjectMocks
    private PayPalConfigurationDataPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldPopulatePayPalConfigurationData() {
        PayPalConfigurationData configurationData = new PayPalConfigurationData();

        when(configurationModel.isPayPalEnable()).thenReturn(true);
        when(configurationModel.isExpressCheckoutEnable()).thenReturn(true);
        when(configurationModel.isPayLaterForNonUsCountries()).thenReturn(false);
        when(configurationModel.getPayPalFundingOnBillingPage()).thenReturn(Set.of(PayPalFunding.PAYLATER));
        when(configurationModel.getPayPalFundingOnExpressCheckout()).thenReturn(Set.of(PayPalFunding.CARD));
        when(configurationModel.isVaultEnabled()).thenReturn(false);
        when(configurationModel.isChangePaymentButtonEnabled()).thenReturn(false);
        when(configurationModel.getSavedPayPalAccountsLimit()).thenReturn(SavedPaymentMethodsLimit.FOUR);

        unit.populate(configurationModel, configurationData);

        assertTrue(configurationData.isPayPalEnable());
        assertTrue(configurationData.isExpressCheckoutEnable());
        assertFalse(configurationData.isPayLaterForNonUsCountries());
        assertEquals((Set.of(PayPalFunding.PAYLATER)), configurationData.getPayPalFundingOnBillingPage());
        assertEquals((Set.of(PayPalFunding.CARD)), configurationData.getPayPalFundingOnExpressCheckout());
        assertFalse(configurationData.isVaultEnabled());
        assertFalse(configurationData.isChangePaymentButtonEnabled());
        assertEquals(SavedPaymentMethodsLimit.FOUR, configurationData.getSavedPayPalAccountsLimit());
    }

}