package com.paypal.hybris.facade.populator;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.core.model.order.CartModel;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;


import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalCartOrderIdPopulatorTest {

    private static final String ORDER_ID_VALUE = "orderId";

    @Mock
    private CartModel cartModel;

    @InjectMocks
    private PayPalCartOrderIdPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldPopulatePayPalCartOrderId() {
        CartData cartData = new CartData();
        when(cartModel.getPayPalOrderId()).thenReturn(ORDER_ID_VALUE);

        unit.populate(cartModel, cartData);

        assertEquals(ORDER_ID_VALUE, cartData.getPayPalOrderId());
    }

}