package com.paypal.hybris.facade.populator;

import com.paypal.hybris.data.AddressPortableData;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.commercefacades.user.data.CountryData;
import de.hybris.platform.commercefacades.user.data.RegionData;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertEquals;

@UnitTest
public class PayPalAddressPortableDataPopulatorTest {

    private static final String MAIN_ST = "123 Main St";
    private static final String APT_4_B = "Apt 4B";
    private static final String CA = "CA";
    private static final String SAN_FRANCISCO = "San Francisco";
    private static final String US = "US";
    private static final String POSTAL_CODE = "94107";

    @InjectMocks
    private PayPalAddressPortableDataPopulator unit;

    private AddressData addressData;
    private AddressPortableData addressPortableData;
    private RegionData regionData;
    private CountryData countryData;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks(this);
        addressData = new AddressData();
        addressPortableData = new AddressPortableData();
        regionData = new RegionData();
        countryData = new CountryData();
    }

    @Test
    public void shouldPopulateAllFields() {
        regionData.setIsocodeShort(CA);
        countryData.setIsocode(US);
        addressData.setLine1(MAIN_ST);
        addressData.setLine2(APT_4_B);
        addressData.setRegion(regionData);
        addressData.setTown(SAN_FRANCISCO);
        addressData.setCountry(countryData);
        addressData.setPostalCode(POSTAL_CODE);

        unit.populate(addressData, addressPortableData);

        assertEquals(MAIN_ST, addressPortableData.getAddressLine1());
        assertEquals(APT_4_B, addressPortableData.getAddressLine2());
        assertEquals(CA, addressPortableData.getAdminArea1());
        assertEquals(SAN_FRANCISCO, addressPortableData.getAdminArea2());
        assertEquals(US, addressPortableData.getCountryCode());
        assertEquals(POSTAL_CODE, addressPortableData.getPostalCode());
    }
}