package com.paypal.hybris.facade.populator;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import com.paypal.hybris.data.PayPalAddressDetailsData;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.commercefacades.user.data.CountryData;
import de.hybris.platform.commercefacades.user.data.RegionData;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;

@UnitTest
public class PayPalAddressDataReversePopulatorTest {

    private static final String FIRST_NAME = "first_name";
    private static final String LAST_NAME = "first_name";
    private static final String EMAIL = "email";
    private static final String COUNTRY_CODE = "country_code";
    private static final String REGION = "region";
    private static final String LINE_1 = "line_1";
    private static final String LINE_2 = "line_2";
    private static final String POSTAL_CODE = "postal_code";
    private static final String CITY = "city";


    private AddressData source = new AddressData();
    private PayPalAddressDetailsData target = new PayPalAddressDetailsData();

    @InjectMocks
    private PayPalAddressDataReversePopulator unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        CountryData country = new CountryData();
        country.setIsocode(COUNTRY_CODE);

        RegionData region = new RegionData();
        region.setIsocodeShort(REGION);

        source.setFirstName(FIRST_NAME);
        source.setLastName(LAST_NAME);
        source.setEmail(EMAIL);
        source.setCountry(country);
        source.setRegion(region);
        source.setLine1(LINE_1);
        source.setLine2(LINE_2);
        source.setPostalCode(POSTAL_CODE);
        source.setTown(CITY);

    }

    @Test
    public void shouldPopulateAddressDataReverse() {
        unit.populate(source, target);

        assertEquals(FIRST_NAME, target.getFirstName());
        assertEquals(LAST_NAME, target.getLastName());
        assertEquals(EMAIL, target.getEmail());
        assertEquals(COUNTRY_CODE, target.getCountryCode());
        assertEquals(REGION, target.getRegion());
        assertEquals(LINE_1, target.getLine1());
        assertEquals(LINE_2, target.getLine2());
        assertEquals(POSTAL_CODE, target.getPostalCode());
        assertEquals(CITY, target.getCity());
    }

    @Test
    public void shouldPopulateAddressDataReverseWhenCountyIsoCodeAndRegionAreNull() {
        source.getCountry().setIsocode(null);
        source.setRegion(null);
        unit.populate(source, target);

        assertEquals(FIRST_NAME, target.getFirstName());
        assertEquals(LAST_NAME, target.getLastName());
        assertEquals(EMAIL, target.getEmail());
        assertNull(target.getCountryCode());
        assertNull(target.getRegion());
        assertEquals(LINE_1, target.getLine1());
        assertEquals(LINE_2, target.getLine2());
        assertEquals(POSTAL_CODE, target.getPostalCode());
        assertEquals(CITY, target.getCity());
    }

}
