package com.paypal.hybris.facade.populator;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

import com.paypal.hybris.data.PayPalAddressDetailsData;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.user.data.AddressData;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;

@UnitTest
public class PayPalAddressDataPopulatorTest {

    private static final String FIRST_NAME = "first_name";
    private static final String LAST_NAME = "first_name";
    private static final String EMAIL = "email";
    private static final String COUNTRY_CODE = "country_code";
    private static final String REGION = "region";
    private static final String LINE_1 = "line_1";
    private static final String LINE_2 = "line_2";
    private static final String POSTAL_CODE = "postal_code";
    private static final String CITY = "city";
    private static final String DASH = "-";

    private final PayPalAddressDetailsData source = new PayPalAddressDetailsData();
    private final AddressData target = new AddressData();

    @InjectMocks
    private PayPalAddressDataPopulator unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        source.setFirstName(FIRST_NAME);
        source.setLastName(LAST_NAME);
        source.setEmail(EMAIL);
        source.setCountryCode(COUNTRY_CODE);
        source.setRegion(REGION);
        source.setLine1(LINE_1);
        source.setLine2(LINE_2);
        source.setPostalCode(POSTAL_CODE);
        source.setCity(CITY);
    }

    @Test
    public void shouldPopulatePayPalAddressData() {
        unit.populate(source, target);

        assertEquals(FIRST_NAME, target.getFirstName());
        assertEquals(LAST_NAME, target.getLastName());
        assertEquals(EMAIL, target.getEmail());
        assertEquals(COUNTRY_CODE, target.getCountry().getIsocode());
        assertEquals(COUNTRY_CODE + DASH + REGION, target.getRegion().getIsocode());
        assertEquals(LINE_1, target.getLine1());
        assertEquals(LINE_2, target.getLine2());
        assertEquals(POSTAL_CODE, target.getPostalCode());
        assertEquals(CITY, target.getTown());
    }

    @Test
    public void shouldPopulatePayPalAddressDataWhenCountyCodeAndRegionAreNull() {
        source.setCountryCode(null);
        source.setRegion(null);
        unit.populate(source, target);

        assertEquals(FIRST_NAME, target.getFirstName());
        assertEquals(LAST_NAME, target.getLastName());
        assertEquals(EMAIL, target.getEmail());
        assertNull(target.getCountry());
        assertNull(target.getRegion());
        assertEquals(LINE_1, target.getLine1());
        assertEquals(LINE_2, target.getLine2());
        assertEquals(POSTAL_CODE, target.getPostalCode());
        assertEquals(CITY, target.getTown());
    }

}
