package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.enums.LocalPaymentFunding;
import com.paypal.hybris.core.model.LocalPaymentsConfigurationModel;
import com.paypal.hybris.data.LocalPaymentsConfigurationData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Set;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.mockito.Mockito.when;

@UnitTest
public class LocalPaymentsConfigurationDataPopulatorTest {

    @Mock
    private LocalPaymentsConfigurationModel configurationModel;

    @InjectMocks
    LocalPaymentsConfigurationDataPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldPopulateData() {
        LocalPaymentsConfigurationData configurationData = new LocalPaymentsConfigurationData();

        when(configurationModel.isEnable()).thenReturn(false);
        when(configurationModel.getFundingsOnBillingPage()).thenReturn(Set.of(LocalPaymentFunding.MYBANK));

        unit.populate(configurationModel, configurationData);

        assertFalse(configurationData.isEnable());
        assertEquals(Set.of(LocalPaymentFunding.MYBANK), configurationData.getFundingsOnBillingPage());
    }

}