package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.enums.HostedFieldsColor;
import com.paypal.hybris.core.model.HostedFieldsStylesConfigurationModel;
import com.paypal.hybris.data.HostedFieldsStylesConfigurationData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;


import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

@UnitTest
public class HostedFieldsStylesConfigPopulatorTest {

    private static final Integer FONT_SIZE_VALUE = 50;

    @Mock
    private HostedFieldsStylesConfigurationModel configurationModel;

    @InjectMocks
    HostedFieldsStylesConfigPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldPopulateHostedFieldsStylesConfig() {
        HostedFieldsStylesConfigurationData configurationData = new HostedFieldsStylesConfigurationData();

        when(configurationModel.getInputColor()).thenReturn(HostedFieldsColor.GREEN);
        when(configurationModel.getInvalidColor()).thenReturn(HostedFieldsColor.BLACK);
        when(configurationModel.getValidColor()).thenReturn(HostedFieldsColor.GRAY);
        when(configurationModel.getFontSize()).thenReturn(FONT_SIZE_VALUE);

        unit.populate(configurationModel, configurationData);

        assertEquals(HostedFieldsColor.GREEN.getCode().toLowerCase(), configurationData.getInputColor());
        assertEquals(HostedFieldsColor.BLACK.getCode().toLowerCase(), configurationData.getInvalidColor());
        assertEquals(HostedFieldsColor.GRAY.getCode().toLowerCase(), configurationData.getValidColor());
        assertEquals(FONT_SIZE_VALUE + "px", configurationData.getFontSize());
    }

}