package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.enums.SavedPaymentMethodsLimit;
import com.paypal.hybris.core.enums.ThreeDsVerificationOnMyAccountType;
import com.paypal.hybris.core.enums.ThreeDsVerificationType;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;
import com.paypal.hybris.data.HostedFieldsConfigurationData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class HostedFieldsConfigurationDataPopulatorTest {

    private static final Integer EXPIRE_BETWEEN_VALUE = 10000;

    @Mock
    private HostedFieldsConfigurationModel configurationModel;

    @InjectMocks
    private HostedFieldsConfigurationDataPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldPopulateHostedFieldsConfigurationData() {
        HostedFieldsConfigurationData configurationData = new HostedFieldsConfigurationData();

        when(configurationModel.isEnable()).thenReturn(true);
        when(configurationModel.getExpireBetween()).thenReturn(EXPIRE_BETWEEN_VALUE);
        when(configurationModel.isExpireOnAdding()).thenReturn(true);
        when(configurationModel.isVaultFlow()).thenReturn(false);
        when(configurationModel.getThreeDsVerificationOnCheckout()).thenReturn(ThreeDsVerificationType.ALWAYS);
        when(configurationModel.getVerificationOnMyAccount()).thenReturn(ThreeDsVerificationOnMyAccountType.SCA_WHEN_REQUIRED);
        when(configurationModel.getSavedCreditCardsLimit()).thenReturn(SavedPaymentMethodsLimit.FIVE);


        unit.populate(configurationModel, configurationData);

        assertTrue(configurationData.isEnable());
        assertEquals(configurationData.getExpireBetween(), EXPIRE_BETWEEN_VALUE);
        assertTrue(configurationData.isExpireOnAdding());
        assertFalse(configurationData.isVaultFlow());
        assertEquals(configurationData.getThreeDsVerificationOnCheckout().toString(), ThreeDsVerificationType.ALWAYS.getCode());
        assertEquals(configurationData.getVerificationOnMyAccount().toString(),
                ThreeDsVerificationOnMyAccountType.SCA_WHEN_REQUIRED.getCode());
        assertEquals(configurationData.getSavedCreditCardsLimit().toString(), SavedPaymentMethodsLimit.FIVE.getCode());
    }

}