package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.model.ConnectWithPayPalConfigurationModel;
import com.paypal.hybris.data.ConnectWithPayPalConfigurationData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class ConnectWithPayPalConfigurationDataPopulatorTest {

    @Mock
    private ConnectWithPayPalConfigurationModel payPalConfigurationModel;

    @InjectMocks
    private ConnectWithPayPalConfigurationDataPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldPopulateConnectWithPayPalConfigurationData() {
        ConnectWithPayPalConfigurationData configurationData = new ConnectWithPayPalConfigurationData();

        when(payPalConfigurationModel.isEnable()).thenReturn(true);
        when(payPalConfigurationModel.isAdditionalSecurity()).thenReturn(true);
        when(payPalConfigurationModel.isAddPaymentMethodFlow()).thenReturn(false);
        when(payPalConfigurationModel.isLinkUserAccount()).thenReturn(true);

        unit.populate(payPalConfigurationModel, configurationData);

        assertTrue(configurationData.isEnable());
        assertTrue(configurationData.isAdditionalSecurity());
        assertFalse(configurationData.isAddPaymentMethodFlow());
        assertTrue(configurationData.isLinkUserAccount());
    }

}