package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.enums.ApplePayButtonType;
import com.paypal.hybris.core.enums.ApplePayColor;
import com.paypal.hybris.core.enums.Location;
import com.paypal.hybris.core.model.ApplePayStylesConfigurationModel;
import com.paypal.hybris.data.ApplePayStylesConfigurationData;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

public class ApplePayStylesConfigPopulatorTest {

    private static final String WHITE_OUTLINE = "white-outline";
    private static final String CHECK_OUT = "check-out";

    @Mock
    private ApplePayStylesConfigurationModel configurationModel;

    @InjectMocks
    private ApplePayStylesConfigPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldPopulatePayPalStylesConfig() {
        ApplePayStylesConfigurationData configurationData = new ApplePayStylesConfigurationData();

        when(configurationModel.getLocation()).thenReturn(Location.MINICART);
        when(configurationModel.getButtonColor()).thenReturn(ApplePayColor.WHITE_OUTLINE);
        when(configurationModel.getButtonType()).thenReturn(ApplePayButtonType.CHECK_OUT);

        unit.populate(configurationModel, configurationData);

        assertEquals(Location.MINICART.getCode().toLowerCase(), configurationData.getLocation());
        assertEquals(WHITE_OUTLINE, configurationData.getColor());
        assertEquals(CHECK_OUT, configurationData.getType());
    }

}
