package com.paypal.hybris.facade.populator;

import com.paypal.hybris.data.ApplePayAddressDetailsData;
import com.paypal.hybris.data.PayPalAddressDetailsData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;

import java.util.ArrayList;
import java.util.List;

import static org.junit.Assert.assertEquals;

@UnitTest
public class ApplePayPayPalAddressDataPopulatorTest {

    private static final String CITY = "city";
    private static final String LINE_1 = "line1";
    private static final String POSTAL_CODE = "postalCode";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "secondName";
    private static final String EMAIL_ADDRESS = "email";
    private static final String PHONE_NUMBER = "phone";
    private static final String US = "US";
    private static final String ADMINISTRATIVE_AREA = "TX";

    private ApplePayAddressDetailsData source;
    private PayPalAddressDetailsData target;

    @InjectMocks
    private ApplePayPayPalAddressDataPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        source = new ApplePayAddressDetailsData();
        target = new PayPalAddressDetailsData();


        source.setLocality(CITY);
        source.setCountryCode(US);
        source.setAddressLines(new ArrayList<>(List.of(LINE_1)));
        source.setPostalCode(POSTAL_CODE);
        source.setGivenName(FIRST_NAME);
        source.setFamilyName(LAST_NAME);
        source.setEmailAddress(EMAIL_ADDRESS);
        source.setPhoneNumber(PHONE_NUMBER);
        source.setAdministrativeArea(ADMINISTRATIVE_AREA);
    }

    @Test
    public void shouldPopulateApplePayAddressDataWithAddressLines() {
        unit.populate(source, target);

        assertEquals(CITY, target.getCity());
        assertEquals(US, target.getCountryCode());
        assertEquals(LINE_1, target.getLine1());
        assertEquals(POSTAL_CODE, target.getPostalCode());
        assertEquals(FIRST_NAME, target.getFirstName());
        assertEquals(LAST_NAME, target.getLastName());
        assertEquals(EMAIL_ADDRESS, target.getEmail());
        assertEquals(PHONE_NUMBER, target.getPhone());
    }


    @Test
    public void shouldPopulateApplePayAddressDataWithoutAddressLines() {
        source.setAddressLines(null);
        unit.populate(source, target);

        assertEquals(CITY, target.getCity());
        assertEquals(US, target.getCountryCode());
        assertEquals(StringUtils.EMPTY, target.getLine1());
        assertEquals(POSTAL_CODE, target.getPostalCode());
        assertEquals(FIRST_NAME, target.getFirstName());
        assertEquals(LAST_NAME, target.getLastName());
        assertEquals(EMAIL_ADDRESS, target.getEmail());
        assertEquals(PHONE_NUMBER, target.getPhone());
    }
}