package com.paypal.hybris.facade.populator;

import com.paypal.hybris.core.model.ApplePayConfigurationModel;
import com.paypal.hybris.data.ApplePayConfigurationData;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

@UnitTest
public class ApplePayConfigurationDataPopulatorTest {

    @Mock
    private ApplePayConfigurationModel applePayConfigurationModel;

    @InjectMocks
    private ApplePayConfigurationDataPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldPopulateApplePayConfigurationData() {
        ApplePayConfigurationData applePayConfigurationData = new ApplePayConfigurationData();
        when(applePayConfigurationModel.isEnable()).thenReturn(true);
        when(applePayConfigurationModel.isExpressCheckoutEnable()).thenReturn(true);

        unit.populate(applePayConfigurationModel, applePayConfigurationData);

        assertTrue(applePayConfigurationData.isEnable());
        assertTrue(applePayConfigurationData.isExpressCheckoutEnable());
    }

}