package com.paypal.hybris.facade.populator;

import com.paypal.hybris.data.ApplePayAddressDetailsData;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.commercefacades.user.data.CountryData;
import de.hybris.platform.commercefacades.user.data.RegionData;
import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertEquals;

@UnitTest
public class ApplePayAddressDataReversePopulatorTest {

    private static final String ID = "ID";
    private static final String CITY = "city";
    private static final String LINE_1 = "line1";
    private static final String LINE_2 = "line2";
    private static final String POSTAL_CODE = "postalCode";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "secondName";
    private static final String EMAIL_ADDRESS = "email";
    private static final String PHONE_NUMBER = "phone";
    private static final String COUNTRY_CODE = "US";
    private static final String COUNTRY_NAME = "United States";
    public static final String ISOCODE_SHORT = "TX";

    private AddressData source;
    private ApplePayAddressDetailsData target;

    @InjectMocks
    private ApplePayAddressDataReversePopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        RegionData regionData = new RegionData();
        regionData.setIsocodeShort(ISOCODE_SHORT);
        CountryData countryData = new CountryData();
        source = new AddressData();
        target = new ApplePayAddressDetailsData();

        countryData.setName(COUNTRY_NAME);
        countryData.setIsocode(COUNTRY_CODE);
        source.setId(ID);
        source.setRegion(regionData);
        source.setTown(CITY);
        source.setCountry(countryData);
        source.setLine1(LINE_1);
        source.setLine2(LINE_2);
        source.setPostalCode(POSTAL_CODE);
        source.setFirstName(FIRST_NAME);
        source.setLastName(LAST_NAME);
        source.setEmail(EMAIL_ADDRESS);
        source.setPhone(PHONE_NUMBER);
    }

    @Test
    public void shouldPopulateAdminAreaWhenRegionIsNotNull() {
        unit.populate(source, target);

        assertEquals(ISOCODE_SHORT, target.getAdministrativeArea());
    }

    @Test
    public void shouldPopulateAdminAreaWithEmptyStringWhenRegionIsNull() {
        source.setRegion(null);

        unit.populate(source, target);

        assertEquals(StringUtils.EMPTY, target.getAdministrativeArea());
    }

    @Test
    public void shouldPopulateAddressDataWithBothAddressLines() {
        unit.populate(source, target);

        assertEquals(ID, target.getId());
        assertEquals(CITY, target.getLocality());
        assertEquals(COUNTRY_CODE, target.getCountryCode());
        assertEquals(COUNTRY_NAME, target.getCountry());
        assertEquals(LINE_1, target.getAddressLines().get(0));
        assertEquals(LINE_2, target.getAddressLines().get(1));
        assertEquals(POSTAL_CODE, target.getPostalCode());
        assertEquals(FIRST_NAME, target.getGivenName());
        assertEquals(LAST_NAME, target.getFamilyName());
        assertEquals(EMAIL_ADDRESS, target.getEmailAddress());
        assertEquals(PHONE_NUMBER, target.getPhoneNumber());
    }


    @Test
    public void shouldPopulateAddressDataWithoutLine2AddressLines() {
        source.setLine2(null);
        unit.populate(source, target);

        assertEquals(CITY, target.getLocality());
        assertEquals(COUNTRY_CODE, target.getCountryCode());
        assertEquals(COUNTRY_NAME, target.getCountry());
        assertEquals(LINE_1, target.getAddressLines().get(0));
        assertEquals(1, target.getAddressLines().size());
        assertEquals(POSTAL_CODE, target.getPostalCode());
        assertEquals(FIRST_NAME, target.getGivenName());
        assertEquals(LAST_NAME, target.getFamilyName());
        assertEquals(EMAIL_ADDRESS, target.getEmailAddress());
        assertEquals(PHONE_NUMBER, target.getPhoneNumber());
    }
}
