package com.paypal.hybris.facade.facades.impl;

import com.paypal.hybris.core.model.HostedFieldsStylesConfigurationModel;
import com.paypal.hybris.core.model.PayPalStylesConfigurationModel;
import com.paypal.hybris.data.HostedFieldsStylesConfigurationData;
import com.paypal.hybris.data.PayPalStylesConfigurationData;
import com.paypal.hybris.facade.service.StylesConfigurationService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultStylesConfigurationFacadeTest {

    private static final String LOCATION = "location";

    @Mock
    private StylesConfigurationService defaultStylesConfigurationService;
    @Mock
    private Converter<HostedFieldsStylesConfigurationModel, HostedFieldsStylesConfigurationData> hostedFieldsStylesConverter;
    @Mock
    private Converter<PayPalStylesConfigurationModel, PayPalStylesConfigurationData> payPalStylesConverter;
    @Mock
    private PayPalStylesConfigurationModel payPalStylesConfigurationModel;
    @Mock
    private HostedFieldsStylesConfigurationModel hostedFieldsStylesConfigurationModel;


    @InjectMocks
    private DefaultStylesConfigurationFacade unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldGetHostedFieldsStylesConfiguration() {
        when(defaultStylesConfigurationService.getHostedFieldsStylesConfiguration())
                .thenReturn(hostedFieldsStylesConfigurationModel);
        when(hostedFieldsStylesConverter.convert(hostedFieldsStylesConfigurationModel))
                .thenReturn(new HostedFieldsStylesConfigurationData());

        unit.getHostedFieldsStylesConfiguration();

        verify(defaultStylesConfigurationService).getHostedFieldsStylesConfiguration();
        verify(hostedFieldsStylesConverter).convert(hostedFieldsStylesConfigurationModel);
    }

    @Test
    public void shouldGetPayPalStylesConfiguration() {
        when(defaultStylesConfigurationService.getPayPalStylesConfiguration(LOCATION))
                .thenReturn(payPalStylesConfigurationModel);
        when(payPalStylesConverter.convert(payPalStylesConfigurationModel))
                .thenReturn(new PayPalStylesConfigurationData());

        unit.getPayPalStylesConfiguration(LOCATION);

        verify(defaultStylesConfigurationService).getPayPalStylesConfiguration(LOCATION);
        verify(payPalStylesConverter).convert(payPalStylesConfigurationModel);
    }

}